/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.InputFile;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableVoiceMessage
implements SendableMessage,
ReplyingOptions {
    @NonNull
    private final InputFile voice;
    private final int duration;
    private final int replyTo;
    private final ReplyMarkup replyMarkup;

    SendableVoiceMessage(InputFile voice, int duration, Message replyTo, ReplyMarkup replyMarkup) {
        this(voice, duration, replyTo != null ? replyTo.getMessageId() : 0, replyMarkup);
    }

    public static SendableVoiceMessageBuilder builder() {
        return new SendableVoiceMessageBuilder();
    }

    @Override
    public MessageType getType() {
        return MessageType.VOICE;
    }

    @ConstructorProperties(value={"voice", "duration", "replyTo", "replyMarkup"})
    public SendableVoiceMessage(@NonNull InputFile voice, int duration, int replyTo, ReplyMarkup replyMarkup) {
        if (voice == null) {
            throw new NullPointerException("voice");
        }
        this.voice = voice;
        this.duration = duration;
        this.replyTo = replyTo;
        this.replyMarkup = replyMarkup;
    }

    @NonNull
    public InputFile getVoice() {
        return this.voice;
    }

    public int getDuration() {
        return this.duration;
    }

    @Override
    public int getReplyTo() {
        return this.replyTo;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public static class SendableVoiceMessageBuilder {
        private InputFile voice;
        private int duration;
        private int replyTo;
        private ReplyMarkup replyMarkup;

        SendableVoiceMessageBuilder() {
        }

        public SendableVoiceMessageBuilder voice(InputFile voice) {
            this.voice = voice;
            return this;
        }

        public SendableVoiceMessageBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public SendableVoiceMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo != null ? replyTo.getMessageId() : 0;
            return this;
        }

        public SendableVoiceMessageBuilder replyTo(int replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableVoiceMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableVoiceMessage build() {
            return new SendableVoiceMessage(this.voice, this.duration, this.replyTo, this.replyMarkup);
        }

        public String toString() {
            return "pro.zackpollard.telegrambot.api.chat.message.send.SendableVoiceMessage.SendableVoiceMessageBuilder(voice=" + this.voice + ", duration=" + this.duration + ", replyTo=" + this.replyTo + ", replyMarkup=" + this.replyMarkup + ")";
        }
    }
}

