/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.updates;

import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.chat.inline.ChosenInlineResult;
import pro.zackpollard.telegrambot.api.chat.inline.InlineQuery;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.internal.chat.inline.ChosenInlineResultImpl;
import pro.zackpollard.telegrambot.api.internal.chat.inline.InlineQueryImpl;
import pro.zackpollard.telegrambot.api.internal.chat.message.MessageImpl;
import pro.zackpollard.telegrambot.api.updates.Update;

public class UpdateImpl
implements Update {
    private final int update_id;
    private final Message message;
    private final InlineQuery inline_query;
    private final ChosenInlineResult chosen_inline_result;
    private Update.UpdateType updateType;

    private UpdateImpl(JSONObject jsonObject) {
        this.update_id = jsonObject.getInt("update_id");
        this.message = MessageImpl.createMessage(jsonObject.optJSONObject("message"));
        if (this.message != null) {
            this.updateType = Update.UpdateType.MESSAGE;
        }
        this.inline_query = InlineQueryImpl.createInlineQuery(jsonObject.optJSONObject("inline_query"));
        if (this.inline_query != null && this.updateType == null) {
            this.updateType = Update.UpdateType.INLINE_QUERY;
        }
        this.chosen_inline_result = ChosenInlineResultImpl.createChosenInlineResult(jsonObject.optJSONObject("chosen_inline_result"));
        if (this.chosen_inline_result != null && this.updateType == null) {
            this.updateType = Update.UpdateType.CHOSEN_INLINE_RESULT;
        }
        System.out.println((Object)this.updateType);
    }

    public static Update createUpdate(JSONObject jsonObject) {
        return new UpdateImpl(jsonObject);
    }

    @Override
    public int getId() {
        return this.update_id;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public InlineQuery getInlineQuery() {
        return this.inline_query;
    }

    @Override
    public ChosenInlineResult getChosenInlineResult() {
        return this.chosen_inline_result;
    }

    @Override
    public Update.UpdateType getType() {
        return this.updateType;
    }
}

