/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.HttpRequestWithBody;
import com.mashape.unirest.request.body.MultipartBody;
import org.json.JSONException;
import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.chat.Chat;
import pro.zackpollard.telegrambot.api.chat.inline.send.InlineQueryResponse;
import pro.zackpollard.telegrambot.api.chat.message.ForceReply;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.content.AudioContent;
import pro.zackpollard.telegrambot.api.chat.message.content.DocumentContent;
import pro.zackpollard.telegrambot.api.chat.message.content.PhotoContent;
import pro.zackpollard.telegrambot.api.chat.message.content.StickerContent;
import pro.zackpollard.telegrambot.api.chat.message.content.VideoContent;
import pro.zackpollard.telegrambot.api.chat.message.content.VoiceContent;
import pro.zackpollard.telegrambot.api.chat.message.content.type.PhotoSize;
import pro.zackpollard.telegrambot.api.chat.message.content.type.Sticker;
import pro.zackpollard.telegrambot.api.chat.message.content.type.Video;
import pro.zackpollard.telegrambot.api.chat.message.content.type.Voice;
import pro.zackpollard.telegrambot.api.chat.message.send.NotificationOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.ParseMode;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableAudioMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableChatAction;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableDocumentMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableForwardMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableLocationMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendablePhotoMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableStickerMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableTextMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableVideoMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableVoiceMessage;
import pro.zackpollard.telegrambot.api.event.ListenerRegistry;
import pro.zackpollard.telegrambot.api.internal.chat.ChannelChatImpl;
import pro.zackpollard.telegrambot.api.internal.chat.GroupChatImpl;
import pro.zackpollard.telegrambot.api.internal.chat.IndividualChatImpl;
import pro.zackpollard.telegrambot.api.internal.chat.SuperGroupChatImpl;
import pro.zackpollard.telegrambot.api.internal.chat.message.MessageImpl;
import pro.zackpollard.telegrambot.api.internal.chat.message.send.FileContainer;
import pro.zackpollard.telegrambot.api.internal.event.ListenerRegistryImpl;
import pro.zackpollard.telegrambot.api.internal.managers.FileManager;
import pro.zackpollard.telegrambot.api.internal.updates.RequestUpdatesManager;
import pro.zackpollard.telegrambot.api.keyboards.ReplyKeyboardHide;
import pro.zackpollard.telegrambot.api.keyboards.ReplyKeyboardMarkup;
import pro.zackpollard.telegrambot.api.updates.UpdateManager;

public final class TelegramBot {
    public static final String API_URL = "https://api.telegram.org/";
    private static final Gson GSON = new GsonBuilder().create();
    private static final FileManager fileManager = new FileManager();
    private final String authToken;
    private final ListenerRegistry listenerRegistry;
    private UpdateManager updateManager = null;
    private final int botID;
    private final String botName;
    private final String botUsername;

    private TelegramBot(String authToken, int botID, String botName, String botUsername) {
        this.authToken = authToken;
        this.botID = botID;
        this.botName = botName;
        this.botUsername = botUsername;
        this.listenerRegistry = ListenerRegistryImpl.getNewInstance();
    }

    public static TelegramBot login(String authToken) {
        try {
            HttpRequestWithBody request = Unirest.post((String)("https://api.telegram.org/bot" + authToken + "/getMe"));
            HttpResponse response = request.asString();
            JSONObject jsonResponse = TelegramBot.processResponse((HttpResponse<String>)response);
            if (jsonResponse != null && TelegramBot.checkResponseStatus(jsonResponse)) {
                JSONObject result = jsonResponse.getJSONObject("result");
                return new TelegramBot(authToken, result.getInt("id"), result.getString("first_name"), result.getString("username"));
            }
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Deprecated
    public static Chat getChat(int chatID) {
        if (chatID < 0) {
            return GroupChatImpl.createGroupChat(chatID);
        }
        return IndividualChatImpl.createIndividualChat(chatID);
    }

    public static Chat getChat(long chatID) {
        if (chatID < 0L) {
            if (chatID > -999999999L) {
                return GroupChatImpl.createGroupChat((int)chatID);
            }
            return SuperGroupChatImpl.createSuperGroupChat(chatID);
        }
        return IndividualChatImpl.createIndividualChat((int)chatID);
    }

    public static Chat getChat(String chatID) {
        if (chatID != null && chatID.length() > 0) {
            long longChatID;
            if (chatID.charAt(0) == '@') {
                return ChannelChatImpl.createChannelChat(chatID);
            }
            try {
                longChatID = Long.parseLong(chatID);
            }
            catch (NumberFormatException e) {
                System.err.println("TelegramBot#getChat(String chatID) was called with invalid ChatID.");
                return null;
            }
            return TelegramBot.getChat(longChatID);
        }
        return null;
    }

    public String getBotAPIUrl() {
        return "https://api.telegram.org/bot" + this.authToken + "/";
    }

    public Message sendMessage(Chat chat, SendableMessage message) {
        JSONObject jsonResponse = null;
        Message messageResponse = null;
        switch (message.getType()) {
            case TEXT: {
                SendableTextMessage textMessage = (SendableTextMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendMessage")).field("chat_id", (Object)chat.getId(), "application/json").field("text", textMessage.getMessage(), "application/json").field("disable_web_page_preview", (Object)textMessage.isDisableWebPagePreview()).field("parse_mode", textMessage.getParseMode() != null ? textMessage.getParseMode().getModeName() : ParseMode.NONE);
                    TelegramBot.processReplyContent(request, textMessage);
                    TelegramBot.processNotificationContent(request, textMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = TelegramBot.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                break;
            }
            case FORWARDED: {
                SendableForwardMessage forwardMessage = (SendableForwardMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "forwardMessage")).field("chat_id", (Object)chat.getId(), "application/json").field("from_chat_id", forwardMessage.getChatID()).field("message_id", (Object)forwardMessage.getMessageID());
                    TelegramBot.processNotificationContent(request, forwardMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = TelegramBot.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                break;
            }
            case PHOTO: {
                SendablePhotoMessage photoMessage = (SendablePhotoMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendPhoto")).field("chat_id", (Object)chat.getId(), "application/json").field("photo", photoMessage.getPhoto().getFileID() != null ? photoMessage.getPhoto().getFileID() : new FileContainer(photoMessage.getPhoto()), photoMessage.getPhoto().getFileID() == null);
                    if (photoMessage.getCaption() != null) {
                        request.field("caption", photoMessage.getCaption(), "application/json");
                    }
                    TelegramBot.processReplyContent(request, photoMessage);
                    TelegramBot.processNotificationContent(request, photoMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = TelegramBot.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                Message message2 = TelegramBot.checkResponseStatus(jsonResponse) ? MessageImpl.createMessage(jsonResponse != null ? jsonResponse : null) : (messageResponse = null);
                if (photoMessage.getPhoto().getFile() == null || messageResponse == null) break;
                PhotoSize[] photoSizes = ((PhotoContent)messageResponse.getContent()).getContent();
                int largestPhotoSize = 0;
                int largestPhotoID = 0;
                for (int i = 0; i < photoSizes.length; ++i) {
                    int size = photoSizes[i].getHeight() * photoSizes[i].getWidth();
                    if (largestPhotoSize >= size) continue;
                    largestPhotoSize = size;
                    largestPhotoID = i;
                }
                fileManager.cacheFileID(photoMessage.getPhoto().getFile(), photoSizes[largestPhotoID].getFileId());
                break;
            }
            case AUDIO: {
                String fileID;
                SendableAudioMessage audioMessage = (SendableAudioMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendAudio")).field("chat_id", (Object)chat.getId(), "application/json").field("audio", audioMessage.getAudio().getFileID() != null ? audioMessage.getAudio().getFileID() : new FileContainer(audioMessage.getAudio()), audioMessage.getAudio().getFileID() == null);
                    TelegramBot.processReplyContent(request, audioMessage);
                    TelegramBot.processNotificationContent(request, audioMessage);
                    if (audioMessage.getDuration() != 0) {
                        request.field("duration", (Object)audioMessage.getDuration());
                    }
                    if (audioMessage.getPerformer() != null) {
                        request.field("performer", audioMessage.getPerformer(), "application/json");
                    }
                    if (audioMessage.getTitle() != null) {
                        request.field("title", audioMessage.getTitle(), "application/json");
                    }
                    HttpResponse response = request.asString();
                    jsonResponse = TelegramBot.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                Message message3 = TelegramBot.checkResponseStatus(jsonResponse) ? MessageImpl.createMessage(jsonResponse != null ? jsonResponse : null) : (messageResponse = null);
                if (audioMessage.getAudio().getFile() == null || messageResponse == null) break;
                switch (messageResponse.getContent().getType()) {
                    case AUDIO: {
                        fileID = ((AudioContent)messageResponse.getContent()).getContent().getFileId();
                        break;
                    }
                    case VOICE: {
                        fileID = ((VoiceContent)messageResponse.getContent()).getContent().getFileId();
                        break;
                    }
                    default: {
                        System.err.println("The API returned content type " + messageResponse.getContent().getType().name() + " when an audio type was sent, this is not supported by this API, please create an issue on github or message @zackpollard on telegram.");
                        return null;
                    }
                }
                fileManager.cacheFileID(audioMessage.getAudio().getFile(), fileID);
                break;
            }
            case DOCUMENT: {
                String fileID;
                SendableDocumentMessage documentMessage = (SendableDocumentMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendDocument")).field("chat_id", (Object)chat.getId(), "application/json").field("document", documentMessage.getDocument().getFileID() != null ? documentMessage.getDocument().getFileID() : new FileContainer(documentMessage.getDocument()), documentMessage.getDocument().getFileID() == null);
                    if (documentMessage.getCaption() != null) {
                        request.field("caption", documentMessage.getCaption(), "application/json");
                    }
                    TelegramBot.processReplyContent(request, documentMessage);
                    TelegramBot.processNotificationContent(request, documentMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = TelegramBot.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                Message message4 = TelegramBot.checkResponseStatus(jsonResponse) ? MessageImpl.createMessage(jsonResponse != null ? jsonResponse : null) : (messageResponse = null);
                if (documentMessage.getDocument().getFile() == null || messageResponse == null) break;
                switch (messageResponse.getContent().getType()) {
                    case AUDIO: {
                        fileID = ((AudioContent)messageResponse.getContent()).getContent().getFileId();
                        break;
                    }
                    case DOCUMENT: {
                        fileID = ((DocumentContent)messageResponse.getContent()).getContent().getFileId();
                        break;
                    }
                    default: {
                        System.err.println("The API returned content type " + messageResponse.getContent().getType().name() + " when a document type was sent, this is not supported by this API, please create an issue on github or message @zackpollard on telegram.");
                        return null;
                    }
                }
                fileManager.cacheFileID(documentMessage.getDocument().getFile(), fileID);
                break;
            }
            case STICKER: {
                SendableStickerMessage stickerMessage = (SendableStickerMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendSticker")).field("chat_id", (Object)chat.getId(), "application/json").field("sticker", stickerMessage.getSticker().getFileID() != null ? stickerMessage.getSticker().getFileID() : new FileContainer(stickerMessage.getSticker()), stickerMessage.getSticker().getFileID() == null);
                    TelegramBot.processReplyContent(request, stickerMessage);
                    TelegramBot.processNotificationContent(request, stickerMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = TelegramBot.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                Message message5 = TelegramBot.checkResponseStatus(jsonResponse) ? MessageImpl.createMessage(jsonResponse != null ? jsonResponse : null) : (messageResponse = null);
                if (stickerMessage.getSticker().getFile() == null || messageResponse == null) break;
                Sticker sticker = ((StickerContent)messageResponse.getContent()).getContent();
                fileManager.cacheFileID(stickerMessage.getSticker().getFile(), sticker.getFileId());
                break;
            }
            case VIDEO: {
                SendableVideoMessage videoMessage = (SendableVideoMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendVideo")).field("chat_id", (Object)chat.getId(), "application/json").field("video", videoMessage.getVideo().getFileID() != null ? videoMessage.getVideo().getFileID() : new FileContainer(videoMessage.getVideo()), videoMessage.getVideo().getFileID() == null);
                    if (videoMessage.getCaption() != null) {
                        request.field("caption", videoMessage.getCaption(), "application/json");
                    }
                    TelegramBot.processReplyContent(request, videoMessage);
                    TelegramBot.processNotificationContent(request, videoMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = TelegramBot.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                Message message6 = TelegramBot.checkResponseStatus(jsonResponse) ? MessageImpl.createMessage(jsonResponse != null ? jsonResponse : null) : (messageResponse = null);
                if (videoMessage.getVideo().getFile() == null || messageResponse == null) break;
                Video video = ((VideoContent)messageResponse.getContent()).getContent();
                fileManager.cacheFileID(videoMessage.getVideo().getFile(), video.getFileId());
                break;
            }
            case VOICE: {
                SendableVoiceMessage voiceMessage = (SendableVoiceMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendVoice")).field("chat_id", (Object)chat.getId(), "application/json").field("voice", voiceMessage.getVoice().getFileID() != null ? voiceMessage.getVoice().getFileID() : new FileContainer(voiceMessage.getVoice()), voiceMessage.getVoice().getFileID() == null);
                    TelegramBot.processReplyContent(request, voiceMessage);
                    TelegramBot.processNotificationContent(request, voiceMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = TelegramBot.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                Message message7 = TelegramBot.checkResponseStatus(jsonResponse) ? MessageImpl.createMessage(jsonResponse != null ? jsonResponse : null) : (messageResponse = null);
                if (voiceMessage.getVoice().getFile() == null || messageResponse == null) break;
                Voice voice = ((VoiceContent)messageResponse.getContent()).getContent();
                fileManager.cacheFileID(voiceMessage.getVoice().getFile(), voice.getFileId());
                break;
            }
            case LOCATION: {
                SendableLocationMessage locationMessage = (SendableLocationMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendLocation")).field("chat_id", (Object)chat.getId(), "application/json").field("latitude", (Object)locationMessage.getLatitude()).field("longitude", (Object)locationMessage.getLongitude());
                    TelegramBot.processReplyContent(request, locationMessage);
                    TelegramBot.processNotificationContent(request, locationMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = TelegramBot.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                break;
            }
            case CHAT_ACTION: {
                SendableChatAction sendableChatAction = (SendableChatAction)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendChatAction")).field("chat_id", (Object)chat.getId(), "application/json").field("action", sendableChatAction.getChatAction().getName());
                    HttpResponse response = request.asString();
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        return TelegramBot.checkResponseStatus(jsonResponse) ? (messageResponse != null ? messageResponse : MessageImpl.createMessage(jsonResponse)) : null;
    }

    public boolean answerInlineQuery(String inlineQueryId, InlineQueryResponse inlineQueryResponse) {
        if (inlineQueryId != null && inlineQueryResponse != null) {
            try {
                MultipartBody requests = Unirest.post((String)(this.getBotAPIUrl() + "answerInlineQuery")).field("inline_query_id", (Object)inlineQueryId).field("results", GSON.toJson(inlineQueryResponse.getResults())).field("cache_time", (Object)inlineQueryResponse.getCacheTime()).field("is_personal", (Object)inlineQueryResponse.isPersonal()).field("next_offset", inlineQueryResponse.getNextOffset());
                HttpResponse response = requests.asString();
                JSONObject jsonResponse = TelegramBot.processResponse((HttpResponse<String>)response);
                if (jsonResponse != null && jsonResponse.getBoolean("result")) {
                    return true;
                }
            }
            catch (UnirestException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void startUpdates(boolean getPreviousUpdates) {
        this.updateManager = new RequestUpdatesManager(this, getPreviousUpdates);
    }

    public ListenerRegistry getEventsManager() {
        return this.listenerRegistry;
    }

    private static JSONObject processResponse(HttpResponse<String> response) {
        block8: {
            if (response != null) {
                if (response.getStatus() == 200) {
                    try {
                        return new JSONObject((String)response.getBody());
                    }
                    catch (JSONException e) {
                        System.err.println("The API didn't return a JSON response. The actual response was " + (String)response.getBody());
                        break block8;
                    }
                }
                JSONObject jsonResponse = null;
                try {
                    jsonResponse = new JSONObject((String)response.getBody());
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                if (jsonResponse != null) {
                    System.err.println("The API returned the following error: " + jsonResponse.getString("description"));
                } else {
                    System.err.println("The API returned error code " + response.getStatus());
                }
            }
        }
        return null;
    }

    private static void processReplyContent(MultipartBody multipartBody, ReplyingOptions replyingOptions) {
        if (replyingOptions.getReplyTo() != 0) {
            multipartBody.field("reply_to_message_id", String.valueOf(replyingOptions.getReplyTo()), "application/json");
        }
        if (replyingOptions.getReplyMarkup() != null) {
            switch (replyingOptions.getReplyMarkup().getType()) {
                case FORCE_REPLY: {
                    multipartBody.field("reply_markup", GSON.toJson((Object)replyingOptions.getReplyMarkup(), ForceReply.class), "application/json");
                    break;
                }
                case KEYBOARD_HIDE: {
                    multipartBody.field("reply_markup", GSON.toJson((Object)replyingOptions.getReplyMarkup(), ReplyKeyboardHide.class), "application/json");
                    break;
                }
                case KEYBOARD_MARKUP: {
                    multipartBody.field("reply_markup", GSON.toJson((Object)replyingOptions.getReplyMarkup(), ReplyKeyboardMarkup.class), "application/json");
                }
            }
        }
    }

    private static void processNotificationContent(MultipartBody multipartBody, NotificationOptions notificationOptions) {
        multipartBody.field("disable_notification", (Object)notificationOptions.isDisableNotification());
    }

    private static boolean checkResponseStatus(JSONObject jsonResponse) {
        if (jsonResponse != null) {
            if (jsonResponse.getBoolean("ok")) {
                return true;
            }
            System.err.println("The API returned the following error: " + jsonResponse.getString("description"));
        } else {
            System.err.println("JSON Response was null, something went wrong...");
        }
        return false;
    }

    public static FileManager getFileManager() {
        return fileManager;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public int getBotID() {
        return this.botID;
    }

    public String getBotName() {
        return this.botName;
    }

    public String getBotUsername() {
        return this.botUsername;
    }
}

