/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import java.net.URL;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.chat.message.send.ParseMode;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultPhoto
implements InlineQueryResult {
    private final InlineQueryResultType type = InlineQueryResultType.PHOTO;
    @NonNull
    private final String id;
    @NonNull
    private final URL photo_url;
    private final int photo_width;
    private final int photo_height;
    @NonNull
    private final URL thumb_url;
    private final String title;
    private final String caption;
    private final String message_text;
    private final ParseMode parse_mode;
    private final boolean disable_web_page_preview;

    public static InlineQueryResultPhotoBuilder builder() {
        return new InlineQueryResultPhotoBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public URL getPhotoUrl() {
        return this.photo_url;
    }

    public int getPhotoWidth() {
        return this.photo_width;
    }

    public int getPhotoHeight() {
        return this.photo_height;
    }

    @NonNull
    public URL getThumbUrl() {
        return this.thumb_url;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getMessageText() {
        return this.message_text;
    }

    public ParseMode getParseMode() {
        return this.parse_mode;
    }

    public boolean isDisableWebPagePreview() {
        return this.disable_web_page_preview;
    }

    private InlineQueryResultPhoto(@NonNull String id, @NonNull URL photo_url, int photo_width, int photo_height, @NonNull URL thumb_url, String title, String caption, String message_text, ParseMode parse_mode, boolean disable_web_page_preview) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (photo_url == null) {
            throw new NullPointerException("photo_url");
        }
        if (thumb_url == null) {
            throw new NullPointerException("thumb_url");
        }
        this.id = id;
        this.photo_url = photo_url;
        this.photo_width = photo_width;
        this.photo_height = photo_height;
        this.thumb_url = thumb_url;
        this.title = title;
        this.caption = caption;
        this.message_text = message_text;
        this.parse_mode = parse_mode;
        this.disable_web_page_preview = disable_web_page_preview;
    }

    public static class InlineQueryResultPhotoBuilder {
        private String id = Utils.generateRandomString(32);
        private URL photo_url;
        private int photo_width;
        private int photo_height;
        private URL thumb_url;
        private String title;
        private String caption;
        private String message_text;
        private ParseMode parse_mode;
        private boolean disable_web_page_preview;

        InlineQueryResultPhotoBuilder() {
        }

        public InlineQueryResultPhotoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultPhotoBuilder photoUrl(URL photoUrl) {
            this.photo_url = photoUrl;
            return this;
        }

        public InlineQueryResultPhotoBuilder photoWidth(int photoWidth) {
            this.photo_width = photoWidth;
            return this;
        }

        public InlineQueryResultPhotoBuilder photoHeight(int photoHeight) {
            this.photo_height = photoHeight;
            return this;
        }

        public InlineQueryResultPhotoBuilder thumbUrl(URL thumbUrl) {
            this.thumb_url = thumbUrl;
            return this;
        }

        public InlineQueryResultPhotoBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InlineQueryResultPhotoBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public InlineQueryResultPhotoBuilder messageText(String messageText) {
            this.message_text = messageText;
            return this;
        }

        public InlineQueryResultPhotoBuilder parseMode(ParseMode parseMode) {
            this.parse_mode = parseMode;
            return this;
        }

        public InlineQueryResultPhotoBuilder disableWebPagePreview(boolean disableWebPagePreview) {
            this.disable_web_page_preview = disableWebPagePreview;
            return this;
        }

        public InlineQueryResultPhoto build() {
            return new InlineQueryResultPhoto(this.id, this.photo_url, this.photo_width, this.photo_height, this.thumb_url, this.title, this.caption, this.message_text, this.parse_mode, this.disable_web_page_preview);
        }

        public String toString() {
            return "pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultPhoto.InlineQueryResultPhotoBuilder(id=" + this.id + ", photo_url=" + this.photo_url + ", photo_width=" + this.photo_width + ", photo_height=" + this.photo_height + ", thumb_url=" + this.thumb_url + ", title=" + this.title + ", caption=" + this.caption + ", message_text=" + this.message_text + ", parse_mode=" + (Object)((Object)this.parse_mode) + ", disable_web_page_preview=" + this.disable_web_page_preview + ")";
        }
    }
}

