/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.io.FilenameUtils;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.internal.FileExtension;
import pro.zackpollard.telegrambot.api.internal.managers.FileManager;

public class InputFile {
    private final String fileID;
    private final File file;
    private final String fileName;

    public InputFile(URL url) {
        File file = TelegramBot.getFileManager().getFile(url);
        String extension = null;
        if (file == null) {
            try {
                String stringifiedUrl = url.toExternalForm();
                HttpResponse response = Unirest.get((String)stringifiedUrl).asBinary();
                extension = FileExtension.getByMimeType(response.getHeaders().getFirst((Object)"content-type"));
                if (extension == null) {
                    extension = stringifiedUrl.substring(stringifiedUrl.lastIndexOf(46) + 1);
                    int variableIndex = extension.indexOf(63);
                    if (variableIndex > 0) {
                        extension = extension.substring(0, variableIndex);
                    }
                    if (extension.length() > 4) {
                        extension = null;
                    }
                }
                file = File.createTempFile("jtb-" + System.currentTimeMillis(), "." + extension, FileManager.getTemporaryFolder());
                file.deleteOnExit();
                TelegramBot.getFileManager().cacheUrl(url, file);
                Files.copy(response.getRawBody(), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (UnirestException | IOException ex) {
                ex.printStackTrace();
            }
        }
        this.fileName = FilenameUtils.getBaseName((String)url.toString()) + "." + extension;
        this.file = file;
        this.fileID = TelegramBot.getFileManager().getFileID(file);
    }

    public InputFile(File file) {
        this.file = file;
        this.fileName = file.getName();
        this.fileID = TelegramBot.getFileManager().getFileID(file);
    }

    public InputFile(String fileID) {
        this.file = null;
        this.fileName = null;
        this.fileID = fileID;
    }

    public String getFileID() {
        return this.fileID;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }
}

