/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.NotificationOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableLocationMessage
implements SendableMessage,
ReplyingOptions,
NotificationOptions {
    @NonNull
    private final double latitude;
    @NonNull
    private final double longitude;
    private final int replyTo;
    private final ReplyMarkup replyMarkup;
    private final boolean disableNotification;

    public SendableLocationMessage(double latitude, double longitude, Message replyTo, ReplyMarkup replyMarkup, boolean disableNotification) {
        this(latitude, longitude, replyTo != null ? replyTo.getMessageId() : 0, replyMarkup, disableNotification);
    }

    public static SendableLocationMessageBuilder builder() {
        return new SendableLocationMessageBuilder();
    }

    @Override
    public MessageType getType() {
        return MessageType.LOCATION;
    }

    @ConstructorProperties(value={"latitude", "longitude", "replyTo", "replyMarkup", "disableNotification"})
    public SendableLocationMessage(@NonNull double latitude, @NonNull double longitude, int replyTo, ReplyMarkup replyMarkup, boolean disableNotification) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.replyTo = replyTo;
        this.replyMarkup = replyMarkup;
        this.disableNotification = disableNotification;
    }

    @NonNull
    public double getLatitude() {
        return this.latitude;
    }

    @NonNull
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public int getReplyTo() {
        return this.replyTo;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Override
    public boolean isDisableNotification() {
        return this.disableNotification;
    }

    public static class SendableLocationMessageBuilder {
        private double latitude;
        private double longitude;
        private int replyTo;
        private ReplyMarkup replyMarkup;
        private boolean disableNotification;

        SendableLocationMessageBuilder() {
        }

        public SendableLocationMessageBuilder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public SendableLocationMessageBuilder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public SendableLocationMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo != null ? replyTo.getMessageId() : 0;
            return this;
        }

        public SendableLocationMessageBuilder replyTo(int replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableLocationMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableLocationMessageBuilder disableNotification(boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        public SendableLocationMessage build() {
            return new SendableLocationMessage(this.latitude, this.longitude, this.replyTo, this.replyMarkup, this.disableNotification);
        }

        public String toString() {
            return "pro.zackpollard.telegrambot.api.chat.message.send.SendableLocationMessage.SendableLocationMessageBuilder(latitude=" + this.latitude + ", longitude=" + this.longitude + ", replyTo=" + this.replyTo + ", replyMarkup=" + this.replyMarkup + ")";
        }
    }
}

