/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.InputFile;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.NotificationOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableStickerMessage
implements SendableMessage,
ReplyingOptions,
NotificationOptions {
    @NonNull
    private final InputFile sticker;
    private final int replyTo;
    private final ReplyMarkup replyMarkup;
    private final boolean disableNotification;

    public SendableStickerMessage(InputFile sticker, Message replyTo, ReplyMarkup replyMarkup, boolean disableNotification) {
        this(sticker, replyTo != null ? replyTo.getMessageId() : 0, replyMarkup, disableNotification);
    }

    public static SendableStickerMessageBuilder builder() {
        return new SendableStickerMessageBuilder();
    }

    @Override
    public MessageType getType() {
        return MessageType.STICKER;
    }

    @ConstructorProperties(value={"sticker", "replyTo", "replyMarkup", "disableNotification"})
    public SendableStickerMessage(@NonNull InputFile sticker, int replyTo, ReplyMarkup replyMarkup, boolean disableNotification) {
        if (sticker == null) {
            throw new NullPointerException("sticker");
        }
        this.sticker = sticker;
        this.replyTo = replyTo;
        this.replyMarkup = replyMarkup;
        this.disableNotification = disableNotification;
    }

    @NonNull
    public InputFile getSticker() {
        return this.sticker;
    }

    @Override
    public int getReplyTo() {
        return this.replyTo;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Override
    public boolean isDisableNotification() {
        return this.disableNotification;
    }

    public static class SendableStickerMessageBuilder {
        private InputFile sticker;
        private int replyTo;
        private ReplyMarkup replyMarkup;
        private boolean disableNotification;

        SendableStickerMessageBuilder() {
        }

        public SendableStickerMessageBuilder sticker(InputFile sticker) {
            this.sticker = sticker;
            return this;
        }

        public SendableStickerMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo != null ? replyTo.getMessageId() : 0;
            return this;
        }

        public SendableStickerMessageBuilder replyTo(int replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableStickerMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableStickerMessageBuilder disableNotification(boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        public SendableStickerMessage build() {
            return new SendableStickerMessage(this.sticker, this.replyTo, this.replyMarkup, this.disableNotification);
        }

        public String toString() {
            return "pro.zackpollard.telegrambot.api.chat.message.send.SendableStickerMessage.SendableStickerMessageBuilder(sticker=" + this.sticker + ", replyTo=" + this.replyTo + ", replyMarkup=" + this.replyMarkup + ")";
        }
    }
}

