/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.InputFile;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.NotificationOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableVideoMessage
implements SendableMessage,
ReplyingOptions,
NotificationOptions {
    @NonNull
    private final InputFile video;
    private final int duration;
    private final String caption;
    private final int replyTo;
    private final ReplyMarkup replyMarkup;
    private final boolean disableNotification;

    SendableVideoMessage(InputFile video, int duration, String caption, Message replyTo, ReplyMarkup replyMarkup, boolean disableNotification) {
        this(video, duration, caption, replyTo != null ? replyTo.getMessageId() : 0, replyMarkup, disableNotification);
    }

    public static SendableVideoMessageBuilder builder() {
        return new SendableVideoMessageBuilder();
    }

    @Override
    public MessageType getType() {
        return MessageType.VIDEO;
    }

    @ConstructorProperties(value={"video", "duration", "caption", "replyTo", "replyMarkup", "disableNotification"})
    public SendableVideoMessage(@NonNull InputFile video, int duration, String caption, int replyTo, ReplyMarkup replyMarkup, boolean disableNotification) {
        if (video == null) {
            throw new NullPointerException("video");
        }
        this.video = video;
        this.duration = duration;
        this.caption = caption;
        this.replyTo = replyTo;
        this.replyMarkup = replyMarkup;
        this.disableNotification = disableNotification;
    }

    @NonNull
    public InputFile getVideo() {
        return this.video;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getCaption() {
        return this.caption;
    }

    @Override
    public int getReplyTo() {
        return this.replyTo;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Override
    public boolean isDisableNotification() {
        return this.disableNotification;
    }

    public static class SendableVideoMessageBuilder {
        private InputFile video;
        private int duration;
        private String caption;
        private int replyTo;
        private ReplyMarkup replyMarkup;
        private boolean disableNotification;

        SendableVideoMessageBuilder() {
        }

        public SendableVideoMessageBuilder video(InputFile video) {
            this.video = video;
            return this;
        }

        public SendableVideoMessageBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public SendableVideoMessageBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public SendableVideoMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo != null ? replyTo.getMessageId() : 0;
            return this;
        }

        public SendableVideoMessageBuilder replyTo(int replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableVideoMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableVideoMessageBuilder disableNotification(boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        public SendableVideoMessage build() {
            return new SendableVideoMessage(this.video, this.duration, this.caption, this.replyTo, this.replyMarkup, this.disableNotification);
        }

        public String toString() {
            return "pro.zackpollard.telegrambot.api.chat.message.send.SendableVideoMessage.SendableVideoMessageBuilder(video=" + this.video + ", duration=" + this.duration + ", caption=" + this.caption + ", replyTo=" + this.replyTo + ", replyMarkup=" + this.replyMarkup + ")";
        }
    }
}

