/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.chat.message;

import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.chat.Chat;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.content.Content;
import pro.zackpollard.telegrambot.api.internal.chat.ChatImpl;
import pro.zackpollard.telegrambot.api.internal.chat.message.content.ContentImpl;
import pro.zackpollard.telegrambot.api.internal.user.UserImpl;
import pro.zackpollard.telegrambot.api.user.User;

public class MessageImpl
implements Message {
    private final JSONObject jsonMessage;
    private final int message_id;
    private final User from;
    private final int date;
    private final Chat chat;
    private final User forward_from;
    private final int forward_date;
    private final Message reply_to_message;
    private final Content content;

    private MessageImpl(JSONObject jsonObject) {
        if (!jsonObject.isNull("result")) {
            jsonObject = jsonObject.getJSONObject("result");
        }
        this.jsonMessage = jsonObject;
        this.message_id = jsonObject.getInt("message_id");
        this.from = UserImpl.createUser(jsonObject.optJSONObject("from"));
        this.date = jsonObject.getInt("date");
        this.chat = ChatImpl.createChat(jsonObject.getJSONObject("chat"));
        this.forward_from = UserImpl.createUser(jsonObject.optJSONObject("forward_from"));
        this.forward_date = jsonObject.optInt("forward_date");
        this.reply_to_message = MessageImpl.createMessage(jsonObject.optJSONObject("reply_to_message"));
        this.content = ContentImpl.createContent(jsonObject);
    }

    public static Message createMessage(JSONObject jsonObject) {
        return jsonObject != null ? new MessageImpl(jsonObject) : null;
    }

    @Override
    public int getMessageId() {
        return this.message_id;
    }

    @Override
    public int getTimeStamp() {
        return this.date;
    }

    @Override
    public User getSender() {
        return this.from;
    }

    @Override
    public Chat getChat() {
        return this.chat;
    }

    @Override
    public User getForwardedFrom() {
        return this.forward_from;
    }

    @Override
    public int getForwardedDate() {
        return this.forward_date;
    }

    @Override
    public Message getRepliedTo() {
        return this.reply_to_message;
    }

    @Override
    public Content getContent() {
        return this.content;
    }

    @Override
    public JSONObject asJson() {
        return this.jsonMessage;
    }
}

