/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.event;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import pro.zackpollard.telegrambot.api.event.Event;
import pro.zackpollard.telegrambot.api.event.Listener;
import pro.zackpollard.telegrambot.api.event.ListenerRegistry;
import pro.zackpollard.telegrambot.api.event.chat.DeleteGroupChatPhotoEvent;
import pro.zackpollard.telegrambot.api.event.chat.GroupChatCreatedEvent;
import pro.zackpollard.telegrambot.api.event.chat.NewGroupChatPhotoEvent;
import pro.zackpollard.telegrambot.api.event.chat.NewGroupChatTitleEvent;
import pro.zackpollard.telegrambot.api.event.chat.ParticipantJoinGroupChatEvent;
import pro.zackpollard.telegrambot.api.event.chat.ParticipantLeaveGroupChatEvent;
import pro.zackpollard.telegrambot.api.event.chat.inline.InlineQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.inline.InlineResultChosenEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.AudioMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.CommandMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.ContactMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.DocumentMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.LocationMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.MessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.PhotoMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.StickerMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.TextMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.VideoMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.VoiceMessageReceivedEvent;

public class ListenerRegistryImpl
implements ListenerRegistry {
    private final Map<Class<?>, BiConsumer<Listener, ? extends Event>> invokers = new HashMap<Class<?>, BiConsumer<Listener, ? extends Event>>(){
        {
            this.register(AudioMessageReceivedEvent.class, Listener::onAudioMessageReceived);
            this.register(CommandMessageReceivedEvent.class, Listener::onCommandMessageReceived);
            this.register(ContactMessageReceivedEvent.class, Listener::onContactMessageReceived);
            this.register(DocumentMessageReceivedEvent.class, Listener::onDocumentMessageReceived);
            this.register(LocationMessageReceivedEvent.class, Listener::onLocationMessageReceived);
            this.register(MessageReceivedEvent.class, Listener::onMessageReceived);
            this.register(PhotoMessageReceivedEvent.class, Listener::onPhotoMessageReceived);
            this.register(StickerMessageReceivedEvent.class, Listener::onStickerMessageReceived);
            this.register(TextMessageReceivedEvent.class, Listener::onTextMessageReceived);
            this.register(VideoMessageReceivedEvent.class, Listener::onVideoMessageReceived);
            this.register(VoiceMessageReceivedEvent.class, Listener::onVoiceMessageReceived);
            this.register(DeleteGroupChatPhotoEvent.class, Listener::onDeleteGroupChatPhoto);
            this.register(GroupChatCreatedEvent.class, Listener::onGroupChatCreated);
            this.register(NewGroupChatPhotoEvent.class, Listener::onNewGroupChatPhoto);
            this.register(NewGroupChatTitleEvent.class, Listener::onNewGroupChatTitle);
            this.register(ParticipantJoinGroupChatEvent.class, Listener::onParticipantJoinGroupChat);
            this.register(ParticipantLeaveGroupChatEvent.class, Listener::onParticipantLeaveGroupChat);
            this.register(InlineQueryReceivedEvent.class, Listener::onInlineQueryReceived);
            this.register(InlineResultChosenEvent.class, Listener::onInlineResultChosen);
        }

        private <T extends Event> void register(Class<T> clazz, BiConsumer<Listener, T> invoker) {
            this.put(clazz, invoker);
        }
    };
    private final Map<Class<?>, Set<Listener>> listenerByContent = new HashMap();

    @Override
    public void register(Listener listener) {
        for (Method m : listener.getClass().getDeclaredMethods()) {
            Class<?>[] classes = m.getParameterTypes();
            if (classes.length != 1) continue;
            Set listeners = this.listenerByContent.computeIfAbsent(classes[0], c -> new LinkedHashSet());
            listeners.add(listener);
        }
    }

    public void callEvent(Event event) {
        BiConsumer<Listener, ? extends Event> invoker = this.invokers.get(event.getClass());
        this.listenerByContent.getOrDefault(event.getClass(), Collections.emptySet()).forEach(listener -> invoker.accept((Listener)listener, event));
    }

    private ListenerRegistryImpl() {
    }

    public static ListenerRegistry getNewInstance() {
        return new ListenerRegistryImpl();
    }
}

