/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.keyboards;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkupType;
import pro.zackpollard.telegrambot.api.keyboards.Keyboard;

public class ReplyKeyboardMarkup
implements Keyboard {
    private final List<List<String>> keyboard;
    private final boolean resize_keyboard;
    private final boolean one_time_keyboard;
    private boolean selective;

    private ReplyKeyboardMarkup(ReplyKeyboardMarkupBuilder builder) {
        this.keyboard = builder.keyboard;
        this.resize_keyboard = builder.resize_keyboard;
        this.one_time_keyboard = builder.one_time_keyboard;
        this.selective = builder.selective;
    }

    public ReplyKeyboardMarkup(List<List<String>> keyboard, boolean resize_keyboard, boolean one_time_keyboard, boolean selective) {
        this.keyboard = keyboard;
        this.resize_keyboard = resize_keyboard;
        this.one_time_keyboard = one_time_keyboard;
        this.selective = selective;
    }

    public static ReplyKeyboardMarkupBuilder builder() {
        return new ReplyKeyboardMarkupBuilder();
    }

    public List<List<String>> getButtons() {
        return this.keyboard;
    }

    public boolean getResize_keyboard() {
        return this.resize_keyboard;
    }

    public boolean getOneTime() {
        return this.one_time_keyboard;
    }

    @Override
    public boolean getSelective() {
        return this.selective;
    }

    @Override
    public void setSelective(boolean selective) {
    }

    @Override
    public ReplyMarkupType getType() {
        return ReplyMarkupType.KEYBOARD_MARKUP;
    }

    public static class ReplyKeyboardMarkupBuilder {
        private final List<List<String>> keyboard = new LinkedList<List<String>>();
        private boolean resize_keyboard = false;
        private boolean one_time_keyboard = false;
        private boolean selective = false;

        private ReplyKeyboardMarkupBuilder() {
        }

        public ReplyKeyboardMarkupBuilder addRow(String ... cellValues) {
            LinkedList<String> list = new LinkedList<String>();
            Collections.addAll(list, cellValues);
            return this.addRow(list);
        }

        public ReplyKeyboardMarkupBuilder addRow(List<String> cellValues) {
            this.keyboard.add(new LinkedList<String>(cellValues));
            return this;
        }

        public ReplyKeyboardMarkupBuilder setRow(int row, String ... cellValues) {
            LinkedList<String> list = new LinkedList<String>();
            Collections.addAll(list, cellValues);
            return this.setRow(row, list);
        }

        public ReplyKeyboardMarkupBuilder setRow(int row, List<String> cellValues) {
            this.keyboard.get(row).clear();
            this.keyboard.get(row).addAll(cellValues);
            return this;
        }

        public ReplyKeyboardMarkupBuilder setCell(int row, int column, String cellValue) {
            this.keyboard.get(row).set(column, cellValue);
            return this;
        }

        public ReplyKeyboardMarkupBuilder resize(boolean resize) {
            this.resize_keyboard = resize;
            return this;
        }

        public ReplyKeyboardMarkupBuilder oneTime(boolean oneTime) {
            this.one_time_keyboard = oneTime;
            return this;
        }

        public ReplyKeyboardMarkupBuilder selective(boolean selective) {
            this.selective = selective;
            return this;
        }

        public ReplyKeyboardMarkup build() {
            return new ReplyKeyboardMarkup(this);
        }
    }
}

