/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import java.net.URL;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.chat.message.send.ParseMode;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultVideo
implements InlineQueryResult {
    private final InlineQueryResultType type = InlineQueryResultType.VIDEO;
    @NonNull
    private final String id;
    @NonNull
    private final URL video_url;
    @NonNull
    private final String mime_type;
    @NonNull
    private final URL thumb_url;
    private final int video_width;
    private final int video_height;
    private final String title;
    private final String caption;
    private final String message_text;
    private final ParseMode parse_mode;
    private final boolean disable_web_page_preview;

    public static InlineQueryResultVideoBuilder builder() {
        return new InlineQueryResultVideoBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return InlineQueryResultType.VIDEO;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public URL getVideoUrl() {
        return this.video_url;
    }

    @NonNull
    public String getMimeType() {
        return this.mime_type;
    }

    @NonNull
    public URL getThumbUrl() {
        return this.thumb_url;
    }

    public int getVideoWidth() {
        return this.video_width;
    }

    public int getVideoHeight() {
        return this.video_height;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getMessageText() {
        return this.message_text;
    }

    public ParseMode getParseMode() {
        return this.parse_mode;
    }

    public boolean isDisableWebPagePreview() {
        return this.disable_web_page_preview;
    }

    private InlineQueryResultVideo(@NonNull String id, @NonNull URL video_url, @NonNull String mime_type, @NonNull URL thumb_url, int video_width, int video_height, String title, String caption, String message_text, ParseMode parse_mode, boolean disable_web_page_preview) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (video_url == null) {
            throw new NullPointerException("video_url");
        }
        if (mime_type == null) {
            throw new NullPointerException("mime_type");
        }
        if (thumb_url == null) {
            throw new NullPointerException("thumb_url");
        }
        this.id = id;
        this.video_url = video_url;
        this.mime_type = mime_type;
        this.thumb_url = thumb_url;
        this.video_width = video_width;
        this.video_height = video_height;
        this.title = title;
        this.caption = caption;
        this.message_text = message_text;
        this.parse_mode = parse_mode;
        this.disable_web_page_preview = disable_web_page_preview;
    }

    public static class InlineQueryResultVideoBuilder {
        private String id = Utils.generateRandomString(32);
        private URL video_url;
        private String mime_type;
        private URL thumb_url;
        private int video_width;
        private int video_height;
        private String title;
        private String caption;
        private String message_text;
        private ParseMode parse_mode;
        private boolean disable_web_page_preview;

        InlineQueryResultVideoBuilder() {
        }

        public InlineQueryResultVideoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultVideoBuilder videoUrl(URL videoUrl) {
            this.video_url = videoUrl;
            return this;
        }

        public InlineQueryResultVideoBuilder mimeType(String mimeType) {
            this.mime_type = mimeType;
            return this;
        }

        public InlineQueryResultVideoBuilder thumbUrl(URL thumbUrl) {
            this.thumb_url = thumbUrl;
            return this;
        }

        public InlineQueryResultVideoBuilder videoWidth(int videoWidth) {
            this.video_width = videoWidth;
            return this;
        }

        public InlineQueryResultVideoBuilder videoHeight(int videoHeight) {
            this.video_height = videoHeight;
            return this;
        }

        public InlineQueryResultVideoBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InlineQueryResultVideoBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public InlineQueryResultVideoBuilder messageText(String messageText) {
            this.message_text = messageText;
            return this;
        }

        public InlineQueryResultVideoBuilder parseMode(ParseMode parseMode) {
            this.parse_mode = parseMode;
            return this;
        }

        public InlineQueryResultVideoBuilder disableWebPagePreview(boolean disableWebPagePreview) {
            this.disable_web_page_preview = disableWebPagePreview;
            return this;
        }

        public InlineQueryResultVideo build() {
            return new InlineQueryResultVideo(this.id, this.video_url, this.mime_type, this.thumb_url, this.video_width, this.video_height, this.title, this.caption, this.message_text, this.parse_mode, this.disable_web_page_preview);
        }

        public String toString() {
            return "pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultVideo.InlineQueryResultVideoBuilder(id=" + this.id + ", video_url=" + this.video_url + ", mime_type=" + this.mime_type + ", thumb_url=" + this.thumb_url + ", video_width=" + this.video_width + ", video_height=" + this.video_height + ", title=" + this.title + ", caption=" + this.caption + ", message_text=" + this.message_text + ", parse_mode=" + (Object)((Object)this.parse_mode) + ", disable_web_page_preview=" + this.disable_web_page_preview + ")";
        }
    }
}

