/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.NotificationOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableForwardMessage
implements SendableMessage,
NotificationOptions {
    @NonNull
    private final Integer messageID;
    @NonNull
    private final String chatID;
    private final boolean disableNotification;

    public static SendableForwardMessageBuilder builder() {
        return new SendableForwardMessageBuilder();
    }

    @Override
    public MessageType getType() {
        return MessageType.FORWARDED;
    }

    private SendableForwardMessage(@NonNull Integer messageID, @NonNull String chatID, boolean disableNotification) {
        if (messageID == null) {
            throw new NullPointerException("messageID");
        }
        if (chatID == null) {
            throw new NullPointerException("chatID");
        }
        this.messageID = messageID;
        this.chatID = chatID;
        this.disableNotification = disableNotification;
    }

    @NonNull
    public Integer getMessageID() {
        return this.messageID;
    }

    @NonNull
    public String getChatID() {
        return this.chatID;
    }

    @Override
    public boolean isDisableNotification() {
        return this.disableNotification;
    }

    public static class SendableForwardMessageBuilder {
        private Integer messageID;
        private String chatID;
        private boolean disableNotification;

        SendableForwardMessageBuilder() {
        }

        public SendableForwardMessageBuilder forwardedMessage(Message forwardedMessage) {
            this.messageID = forwardedMessage != null ? Integer.valueOf(forwardedMessage.getMessageId()) : null;
            this.chatID = forwardedMessage != null ? forwardedMessage.getChat().getId() : null;
            return this;
        }

        public SendableForwardMessageBuilder messageID(Integer messageID) {
            this.messageID = messageID;
            return this;
        }

        public SendableForwardMessageBuilder chatID(String chatID) {
            this.chatID = chatID;
            return this;
        }

        public SendableForwardMessageBuilder disableNotification(boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        public SendableForwardMessage build() {
            return new SendableForwardMessage(this.messageID, this.chatID, this.disableNotification);
        }

        public String toString() {
            return "pro.zackpollard.telegrambot.api.chat.message.send.SendableForwardMessage.SendableForwardMessageBuilder(messageID=" + this.messageID + ", chatID=" + this.chatID + ")";
        }
    }
}

