/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.NotificationOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.ParseMode;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableTextMessage
implements SendableMessage,
ReplyingOptions,
NotificationOptions {
    @NonNull
    private final String message;
    private final int replyTo;
    private final boolean disableWebPagePreview;
    private final ReplyMarkup replyMarkup;
    private final ParseMode parseMode;
    private final boolean disableNotification;

    public static SendableTextMessageBuilder builder() {
        return new SendableTextMessageBuilder();
    }

    @Override
    public MessageType getType() {
        return MessageType.TEXT;
    }

    private SendableTextMessage(@NonNull String message, int replyTo, boolean disableWebPagePreview, ReplyMarkup replyMarkup, ParseMode parseMode, boolean disableNotification) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.message = message;
        this.replyTo = replyTo;
        this.disableWebPagePreview = disableWebPagePreview;
        this.replyMarkup = replyMarkup;
        this.parseMode = parseMode;
        this.disableNotification = disableNotification;
    }

    @NonNull
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getReplyTo() {
        return this.replyTo;
    }

    public boolean isDisableWebPagePreview() {
        return this.disableWebPagePreview;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public ParseMode getParseMode() {
        return this.parseMode;
    }

    @Override
    public boolean isDisableNotification() {
        return this.disableNotification;
    }

    public static class SendableTextMessageBuilder {
        private String message;
        private int replyTo;
        private boolean disableWebPagePreview;
        private ReplyMarkup replyMarkup;
        private ParseMode parseMode;
        private boolean disableNotification;

        SendableTextMessageBuilder() {
        }

        public SendableTextMessageBuilder message(String message) {
            this.message = message;
            return this;
        }

        public SendableTextMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo != null ? replyTo.getMessageId() : 0;
            return this;
        }

        public SendableTextMessageBuilder replyTo(int replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableTextMessageBuilder disableWebPagePreview(boolean disableWebPagePreview) {
            this.disableWebPagePreview = disableWebPagePreview;
            return this;
        }

        public SendableTextMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableTextMessageBuilder parseMode(ParseMode parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public SendableTextMessageBuilder disableNotification(boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        public SendableTextMessage build() {
            return new SendableTextMessage(this.message, this.replyTo, this.disableWebPagePreview, this.replyMarkup, this.parseMode, this.disableNotification);
        }

        public String toString() {
            return "pro.zackpollard.telegrambot.api.chat.message.send.SendableTextMessage.SendableTextMessageBuilder(message=" + this.message + ", replyTo=" + this.replyTo + ", disableWebPagePreview=" + this.disableWebPagePreview + ", replyMarkup=" + this.replyMarkup + ", parseMode=" + (Object)((Object)this.parseMode) + ")";
        }
    }
}

