/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send;

import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;

public class InlineQueryResponse {
    @NonNull
    private final List<InlineQueryResult> results;
    private final Integer cache_time;
    private final boolean is_personal;
    private final String next_offset;

    public static InlineQueryResponseBuilder builder() {
        return new InlineQueryResponseBuilder();
    }

    @NonNull
    public List<InlineQueryResult> getResults() {
        return this.results;
    }

    public Integer getCacheTime() {
        return this.cache_time;
    }

    public boolean isPersonal() {
        return this.is_personal;
    }

    public String getNextOffset() {
        return this.next_offset;
    }

    private InlineQueryResponse(@NonNull List<InlineQueryResult> results, Integer cache_time, boolean is_personal, String next_offset) {
        if (results == null) {
            throw new NullPointerException("results");
        }
        this.results = results;
        this.cache_time = cache_time;
        this.is_personal = is_personal;
        this.next_offset = next_offset;
    }

    public static class InlineQueryResponseBuilder {
        private List<InlineQueryResult> results;
        private Integer cache_time = 300;
        private boolean is_personal = false;
        private String next_offset = "";

        InlineQueryResponseBuilder() {
        }

        public InlineQueryResponseBuilder results(List<InlineQueryResult> results) {
            this.results = results;
            return this;
        }

        public InlineQueryResponseBuilder results(InlineQueryResult ... results) {
            this.results = Arrays.asList(results);
            return this;
        }

        public InlineQueryResponseBuilder cache_time(Integer cache_time) {
            this.cache_time = cache_time;
            return this;
        }

        public InlineQueryResponseBuilder is_personal(boolean is_personal) {
            this.is_personal = is_personal;
            return this;
        }

        public InlineQueryResponseBuilder next_offset(String next_offset) {
            this.next_offset = next_offset;
            return this;
        }

        public InlineQueryResponse build() {
            return new InlineQueryResponse(this.results, this.cache_time, this.is_personal, this.next_offset);
        }

        public String toString() {
            return "pro.zackpollard.telegrambot.api.chat.inline.send.InlineQueryResponse.InlineQueryResponseBuilder(results=" + this.results + ", cache_time=" + this.cache_time + ", is_personal=" + this.is_personal + ", next_offset=" + this.next_offset + ")";
        }
    }
}

