/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.InlineReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContent;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultCachedVoice
implements InlineQueryResult {
    private final InlineQueryResultType type = InlineQueryResultType.VOICE;
    @NonNull
    private final String id;
    @NonNull
    private final String voice_file_id;
    @NonNull
    private final String title;
    private final InlineReplyMarkup reply_markup;
    private final InputMessageContent input_message_content;

    public static InlineQueryResultCachedVoiceBuilder builder() {
        return new InlineQueryResultCachedVoiceBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getVoiceFileId() {
        return this.voice_file_id;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    public InlineReplyMarkup getReplyMarkup() {
        return this.reply_markup;
    }

    public InputMessageContent getInputMessageContent() {
        return this.input_message_content;
    }

    public String toString() {
        return "InlineQueryResultCachedVoice(type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", voice_file_id=" + this.voice_file_id + ", title=" + this.getTitle() + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ")";
    }

    private InlineQueryResultCachedVoice(@NonNull String id, @NonNull String voice_file_id, @NonNull String title, InlineReplyMarkup reply_markup, InputMessageContent input_message_content) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (voice_file_id == null) {
            throw new NullPointerException("voice_file_id");
        }
        if (title == null) {
            throw new NullPointerException("title");
        }
        this.id = id;
        this.voice_file_id = voice_file_id;
        this.title = title;
        this.reply_markup = reply_markup;
        this.input_message_content = input_message_content;
    }

    public static class InlineQueryResultCachedVoiceBuilder {
        private String id = Utils.generateRandomString(32);
        private String voice_file_id;
        private String title;
        private InlineReplyMarkup reply_markup;
        private InputMessageContent input_message_content;

        InlineQueryResultCachedVoiceBuilder() {
        }

        public InlineQueryResultCachedVoiceBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultCachedVoiceBuilder voiceFileId(String voiceFileId) {
            this.voice_file_id = voiceFileId;
            return this;
        }

        public InlineQueryResultCachedVoiceBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InlineQueryResultCachedVoiceBuilder replyMarkup(InlineReplyMarkup replyMarkup) {
            this.reply_markup = replyMarkup;
            return this;
        }

        public InlineQueryResultCachedVoiceBuilder input_message_content(InputMessageContent inputMessageContent) {
            this.input_message_content = inputMessageContent;
            return this;
        }

        public InlineQueryResultCachedVoice build() {
            return new InlineQueryResultCachedVoice(this.id, this.voice_file_id, this.title, this.reply_markup, this.input_message_content);
        }

        public String toString() {
            return "InlineQueryResultCachedVoice.InlineQueryResultCachedVoiceBuilder(id=" + this.id + ", voice_file_id=" + this.voice_file_id + ", title=" + this.title + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ")";
        }
    }
}

