/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import java.net.URL;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.InlineReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContent;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultVoice
implements InlineQueryResult {
    private final InlineQueryResultType type = InlineQueryResultType.VOICE;
    @NonNull
    private final String id;
    @NonNull
    private final URL voice_url;
    @NonNull
    private final String title;
    private final Integer voice_duration;
    private final InlineReplyMarkup reply_markup;
    private final InputMessageContent input_message_content;

    public static InlineQueryResultVoiceBuilder builder() {
        return new InlineQueryResultVoiceBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public URL getVoiceUrl() {
        return this.voice_url;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    public Integer getVoiceDuration() {
        return this.voice_duration;
    }

    public InlineReplyMarkup getReplyMarkup() {
        return this.reply_markup;
    }

    public InputMessageContent getInputMessageContent() {
        return this.input_message_content;
    }

    public String toString() {
        return "InlineQueryResultVoice(type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", voice_url=" + this.voice_url + ", title=" + this.getTitle() + ", voice_duration=" + this.voice_duration + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ")";
    }

    private InlineQueryResultVoice(@NonNull String id, @NonNull URL voice_url, @NonNull String title, Integer voice_duration, InlineReplyMarkup reply_markup, InputMessageContent input_message_content) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (voice_url == null) {
            throw new NullPointerException("voice_url");
        }
        if (title == null) {
            throw new NullPointerException("title");
        }
        this.id = id;
        this.voice_url = voice_url;
        this.title = title;
        this.voice_duration = voice_duration;
        this.reply_markup = reply_markup;
        this.input_message_content = input_message_content;
    }

    public static class InlineQueryResultVoiceBuilder {
        private String id = Utils.generateRandomString(32);
        private URL voice_url;
        private String title;
        private Integer voice_duration;
        private InlineReplyMarkup reply_markup;
        private InputMessageContent input_message_content;

        InlineQueryResultVoiceBuilder() {
        }

        public InlineQueryResultVoiceBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultVoiceBuilder voiceUrl(URL voiceUrl) {
            this.voice_url = voiceUrl;
            return this;
        }

        public InlineQueryResultVoiceBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InlineQueryResultVoiceBuilder voiceDuration(Integer voiceDuration) {
            this.voice_duration = voiceDuration;
            return this;
        }

        public InlineQueryResultVoiceBuilder replyMarkup(InlineReplyMarkup replyMarkup) {
            this.reply_markup = replyMarkup;
            return this;
        }

        public InlineQueryResultVoiceBuilder input_message_content(InputMessageContent inputMessageContent) {
            this.input_message_content = inputMessageContent;
            return this;
        }

        public InlineQueryResultVoice build() {
            return new InlineQueryResultVoice(this.id, this.voice_url, this.title, this.voice_duration, this.reply_markup, this.input_message_content);
        }

        public String toString() {
            return "InlineQueryResultVoice.InlineQueryResultVoiceBuilder(id=" + this.id + ", voice_url=" + this.voice_url + ", title=" + this.title + ", voice_duration=" + this.voice_duration + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ")";
        }
    }
}

