/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.managers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class FileManager {
    private static MessageDigest md5Digest;
    private static File tmpDirectory;
    private final Map<String, String> checksumIDs = new HashMap<String, String>();
    private final Map<String, String> urlCache = new HashMap<String, String>();

    public FileManager() {
        if (md5Digest == null) {
            try {
                md5Digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getFileChecksum(File file) throws IOException {
        int bytesCount;
        FileInputStream fis = new FileInputStream(file);
        byte[] byteArray = new byte[1024];
        while ((bytesCount = fis.read(byteArray)) != -1) {
            md5Digest.update(byteArray, 0, bytesCount);
        }
        fis.close();
        byte[] bytes = md5Digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            sb.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    public String getFileID(File file) {
        String checksum = null;
        try {
            checksum = FileManager.getFileChecksum(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String fileID = this.checksumIDs.get(checksum);
        if (fileID != null) {
            return fileID;
        }
        return null;
    }

    public String cacheFileID(File file, String fileID) {
        String checksum = null;
        try {
            checksum = FileManager.getFileChecksum(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (checksum != null) {
            this.checksumIDs.put(checksum, fileID);
        }
        return checksum;
    }

    public File getFile(URL url) {
        String path = this.urlCache.get(url.getPath());
        return path != null ? new File(path) : null;
    }

    public void cacheUrl(URL url, File file) {
        this.urlCache.put(url.getPath(), file.getAbsolutePath());
    }

    public static File getTemporaryFolder() {
        return tmpDirectory;
    }

    static {
        tmpDirectory = new File(System.getProperty("java.io.tmpdir"), "jtelegrambot-" + System.currentTimeMillis());
        tmpDirectory.mkdirs();
    }
}

