/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.HttpRequestWithBody;
import com.mashape.unirest.request.body.MultipartBody;
import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.chat.Chat;
import pro.zackpollard.telegrambot.api.chat.inline.InlineReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.inline.send.InlineQueryResponse;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.content.AudioContent;
import pro.zackpollard.telegrambot.api.chat.message.content.ContentType;
import pro.zackpollard.telegrambot.api.chat.message.content.DocumentContent;
import pro.zackpollard.telegrambot.api.chat.message.content.PhotoContent;
import pro.zackpollard.telegrambot.api.chat.message.content.StickerContent;
import pro.zackpollard.telegrambot.api.chat.message.content.VideoContent;
import pro.zackpollard.telegrambot.api.chat.message.content.VoiceContent;
import pro.zackpollard.telegrambot.api.chat.message.content.type.PhotoSize;
import pro.zackpollard.telegrambot.api.chat.message.content.type.Sticker;
import pro.zackpollard.telegrambot.api.chat.message.content.type.Video;
import pro.zackpollard.telegrambot.api.chat.message.content.type.Voice;
import pro.zackpollard.telegrambot.api.chat.message.send.ParseMode;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableAudioMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableChatAction;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableDocumentMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableForwardMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableLocationMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendablePhotoMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableStickerMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableTextMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableVenueMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableVideoMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableVoiceMessage;
import pro.zackpollard.telegrambot.api.event.ListenerRegistry;
import pro.zackpollard.telegrambot.api.internal.chat.ChatImpl;
import pro.zackpollard.telegrambot.api.internal.chat.message.MessageImpl;
import pro.zackpollard.telegrambot.api.internal.chat.message.send.FileContainer;
import pro.zackpollard.telegrambot.api.internal.event.ListenerRegistryImpl;
import pro.zackpollard.telegrambot.api.internal.managers.FileManager;
import pro.zackpollard.telegrambot.api.internal.updates.RequestUpdatesManager;
import pro.zackpollard.telegrambot.api.keyboards.InlineKeyboardMarkup;
import pro.zackpollard.telegrambot.api.updates.UpdateManager;
import pro.zackpollard.telegrambot.api.utils.Utils;

public final class TelegramBot {
    public static final String API_URL = "https://api.telegram.org/";
    public static final Gson GSON = new GsonBuilder().create();
    private static final FileManager fileManager = new FileManager();
    private final String authToken;
    private final ListenerRegistry listenerRegistry;
    private UpdateManager updateManager = null;
    private final int botID;
    private final String botName;
    private final String botUsername;

    private TelegramBot(String authToken, int botID, String botName, String botUsername) {
        this.authToken = authToken;
        this.botID = botID;
        this.botName = botName;
        this.botUsername = botUsername;
        this.listenerRegistry = ListenerRegistryImpl.getNewInstance();
    }

    public static TelegramBot login(String authToken) {
        try {
            HttpRequestWithBody request = Unirest.post((String)("https://api.telegram.org/bot" + authToken + "/getMe"));
            HttpResponse response = request.asString();
            JSONObject jsonResponse = Utils.processResponse((HttpResponse<String>)response);
            if (jsonResponse != null && Utils.checkResponseStatus(jsonResponse)) {
                JSONObject result = jsonResponse.getJSONObject("result");
                return new TelegramBot(authToken, result.getInt("id"), result.getString("first_name"), result.getString("username"));
            }
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Chat getChat(long chatID) {
        return this.getChat(String.valueOf(chatID));
    }

    public Chat getChat(String chatID) {
        try {
            MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "getChat")).field("chat_id", (Object)chatID, "application/json");
            HttpResponse response = request.asString();
            JSONObject jsonResponse = Utils.processResponse((HttpResponse<String>)response);
            if (jsonResponse != null && Utils.checkResponseStatus(jsonResponse)) {
                JSONObject result = jsonResponse.getJSONObject("result");
                return ChatImpl.createChat(result, this);
            }
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getBotAPIUrl() {
        return "https://api.telegram.org/bot" + this.authToken + "/";
    }

    public Message sendMessage(Chat chat, SendableMessage message) {
        JSONObject jsonResponse = null;
        Message messageResponse = null;
        switch (message.getType()) {
            case TEXT: {
                SendableTextMessage textMessage = (SendableTextMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendMessage")).field("chat_id", (Object)chat.getId(), "application/json").field("text", textMessage.getMessage(), "application/json").field("disable_web_page_preview", (Object)textMessage.isDisableWebPagePreview()).field("parse_mode", textMessage.getParseMode() != null ? textMessage.getParseMode().getModeName() : ParseMode.NONE);
                    Utils.processReplyContent(request, textMessage);
                    Utils.processNotificationContent(request, textMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = Utils.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                break;
            }
            case FORWARDED: {
                SendableForwardMessage forwardMessage = (SendableForwardMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "forwardMessage")).field("chat_id", (Object)chat.getId(), "application/json").field("from_chat_id", forwardMessage.getChatID()).field("message_id", (Object)forwardMessage.getMessageID());
                    Utils.processNotificationContent(request, forwardMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = Utils.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                break;
            }
            case PHOTO: {
                SendablePhotoMessage photoMessage = (SendablePhotoMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendPhoto")).field("chat_id", (Object)chat.getId(), "application/json").field("photo", photoMessage.getPhoto().getFileID() != null ? photoMessage.getPhoto().getFileID() : new FileContainer(photoMessage.getPhoto()), photoMessage.getPhoto().getFileID() == null);
                    if (photoMessage.getCaption() != null) {
                        request.field("caption", photoMessage.getCaption(), "application/json");
                    }
                    Utils.processReplyContent(request, photoMessage);
                    Utils.processNotificationContent(request, photoMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = Utils.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                Message message2 = Utils.checkResponseStatus(jsonResponse) ? MessageImpl.createMessage(jsonResponse != null ? jsonResponse : null, this) : (messageResponse = null);
                if (photoMessage.getPhoto().getFile() == null || messageResponse == null) break;
                if (!messageResponse.getContent().getType().equals((Object)ContentType.PHOTO)) {
                    System.err.println("The API returned content type " + messageResponse.getContent().getType().name() + " when a " + (Object)((Object)message.getType()) + " type was sent, this is not supported by this API and will break cacheing, please create an issue on github or message @zackpollard on telegram.");
                    break;
                }
                PhotoSize[] photoSizes = ((PhotoContent)messageResponse.getContent()).getContent();
                int largestPhotoSize = 0;
                int largestPhotoID = 0;
                for (int i = 0; i < photoSizes.length; ++i) {
                    int size = photoSizes[i].getHeight() * photoSizes[i].getWidth();
                    if (largestPhotoSize >= size) continue;
                    largestPhotoSize = size;
                    largestPhotoID = i;
                }
                fileManager.cacheFileID(photoMessage.getPhoto().getFile(), photoSizes[largestPhotoID].getFileId());
                break;
            }
            case AUDIO: {
                String fileID;
                SendableAudioMessage audioMessage = (SendableAudioMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendAudio")).field("chat_id", (Object)chat.getId(), "application/json").field("audio", audioMessage.getAudio().getFileID() != null ? audioMessage.getAudio().getFileID() : new FileContainer(audioMessage.getAudio()), audioMessage.getAudio().getFileID() == null);
                    Utils.processReplyContent(request, audioMessage);
                    Utils.processNotificationContent(request, audioMessage);
                    if (audioMessage.getDuration() != 0) {
                        request.field("duration", (Object)audioMessage.getDuration());
                    }
                    if (audioMessage.getPerformer() != null) {
                        request.field("performer", audioMessage.getPerformer(), "application/json");
                    }
                    if (audioMessage.getTitle() != null) {
                        request.field("title", audioMessage.getTitle(), "application/json");
                    }
                    HttpResponse response = request.asString();
                    jsonResponse = Utils.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                Message message3 = Utils.checkResponseStatus(jsonResponse) ? MessageImpl.createMessage(jsonResponse != null ? jsonResponse : null, this) : (messageResponse = null);
                if (audioMessage.getAudio().getFile() == null || messageResponse == null) break;
                switch (messageResponse.getContent().getType()) {
                    case AUDIO: {
                        fileID = ((AudioContent)messageResponse.getContent()).getContent().getFileId();
                        break;
                    }
                    case VOICE: {
                        fileID = ((VoiceContent)messageResponse.getContent()).getContent().getFileId();
                        break;
                    }
                    default: {
                        System.err.println("The API returned content type " + messageResponse.getContent().getType().name() + " when an audio type was sent, this is not supported by this API, please create an issue on github or message @zackpollard on telegram.");
                        return null;
                    }
                }
                fileManager.cacheFileID(audioMessage.getAudio().getFile(), fileID);
                break;
            }
            case DOCUMENT: {
                String fileID;
                SendableDocumentMessage documentMessage = (SendableDocumentMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendDocument")).field("chat_id", (Object)chat.getId(), "application/json").field("document", documentMessage.getDocument().getFileID() != null ? documentMessage.getDocument().getFileID() : new FileContainer(documentMessage.getDocument()), documentMessage.getDocument().getFileID() == null);
                    if (documentMessage.getCaption() != null) {
                        request.field("caption", documentMessage.getCaption(), "application/json");
                    }
                    Utils.processReplyContent(request, documentMessage);
                    Utils.processNotificationContent(request, documentMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = Utils.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                Message message4 = Utils.checkResponseStatus(jsonResponse) ? MessageImpl.createMessage(jsonResponse != null ? jsonResponse : null, this) : (messageResponse = null);
                if (documentMessage.getDocument().getFile() == null || messageResponse == null) break;
                switch (messageResponse.getContent().getType()) {
                    case AUDIO: {
                        fileID = ((AudioContent)messageResponse.getContent()).getContent().getFileId();
                        break;
                    }
                    case DOCUMENT: {
                        fileID = ((DocumentContent)messageResponse.getContent()).getContent().getFileId();
                        break;
                    }
                    default: {
                        System.err.println("The API returned content type " + messageResponse.getContent().getType().name() + " when a document type was sent, this is not supported by this API, please create an issue on github or message @zackpollard on telegram.");
                        return null;
                    }
                }
                fileManager.cacheFileID(documentMessage.getDocument().getFile(), fileID);
                break;
            }
            case STICKER: {
                SendableStickerMessage stickerMessage = (SendableStickerMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendSticker")).field("chat_id", (Object)chat.getId(), "application/json").field("sticker", stickerMessage.getSticker().getFileID() != null ? stickerMessage.getSticker().getFileID() : new FileContainer(stickerMessage.getSticker()), stickerMessage.getSticker().getFileID() == null);
                    Utils.processReplyContent(request, stickerMessage);
                    Utils.processNotificationContent(request, stickerMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = Utils.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                Message message5 = Utils.checkResponseStatus(jsonResponse) ? MessageImpl.createMessage(jsonResponse != null ? jsonResponse : null, this) : (messageResponse = null);
                if (stickerMessage.getSticker().getFile() == null || messageResponse == null) break;
                if (!messageResponse.getContent().getType().equals((Object)ContentType.STICKER)) {
                    System.err.println("The API returned content type " + messageResponse.getContent().getType().name() + " when a " + (Object)((Object)message.getType()) + " type was sent, this is not supported by this API and will break cacheing, please create an issue on github or message @zackpollard on telegram.");
                    break;
                }
                Sticker sticker = ((StickerContent)messageResponse.getContent()).getContent();
                fileManager.cacheFileID(stickerMessage.getSticker().getFile(), sticker.getFileId());
                break;
            }
            case VIDEO: {
                SendableVideoMessage videoMessage = (SendableVideoMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendVideo")).field("chat_id", (Object)chat.getId(), "application/json").field("video", videoMessage.getVideo().getFileID() != null ? videoMessage.getVideo().getFileID() : new FileContainer(videoMessage.getVideo()), videoMessage.getVideo().getFileID() == null);
                    if (videoMessage.getDuration() > 0) {
                        request.field("duration", (Object)videoMessage.getDuration());
                    }
                    if (videoMessage.getWidth() > 0) {
                        request.field("width", (Object)videoMessage.getWidth());
                    }
                    if (videoMessage.getHeight() > 0) {
                        request.field("height", (Object)videoMessage.getHeight());
                    }
                    if (videoMessage.getCaption() != null) {
                        request.field("caption", videoMessage.getCaption(), "application/json");
                    }
                    Utils.processReplyContent(request, videoMessage);
                    Utils.processNotificationContent(request, videoMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = Utils.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                Message message6 = Utils.checkResponseStatus(jsonResponse) ? MessageImpl.createMessage(jsonResponse != null ? jsonResponse : null, this) : (messageResponse = null);
                if (videoMessage.getVideo().getFile() == null || messageResponse == null) break;
                if (!messageResponse.getContent().getType().equals((Object)ContentType.VIDEO)) {
                    System.err.println("The API returned content type " + messageResponse.getContent().getType().name() + " when a " + (Object)((Object)message.getType()) + " type was sent, this is not supported by this API and will break cacheing, please create an issue on github or message @zackpollard on telegram.");
                    break;
                }
                Video video = ((VideoContent)messageResponse.getContent()).getContent();
                fileManager.cacheFileID(videoMessage.getVideo().getFile(), video.getFileId());
                break;
            }
            case VOICE: {
                SendableVoiceMessage voiceMessage = (SendableVoiceMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendVoice")).field("chat_id", (Object)chat.getId(), "application/json").field("voice", voiceMessage.getVoice().getFileID() != null ? voiceMessage.getVoice().getFileID() : new FileContainer(voiceMessage.getVoice()), voiceMessage.getVoice().getFileID() == null);
                    if (voiceMessage.getDuration() > 0) {
                        request.field("duration", (Object)voiceMessage.getDuration());
                    }
                    Utils.processReplyContent(request, voiceMessage);
                    Utils.processNotificationContent(request, voiceMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = Utils.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                Message message7 = Utils.checkResponseStatus(jsonResponse) ? MessageImpl.createMessage(jsonResponse != null ? jsonResponse : null, this) : (messageResponse = null);
                if (voiceMessage.getVoice().getFile() == null || messageResponse == null) break;
                if (!messageResponse.getContent().getType().equals((Object)ContentType.VOICE)) {
                    System.err.println("The API returned content type " + messageResponse.getContent().getType().name() + " when a " + (Object)((Object)message.getType()) + " type was sent, this is not supported by this API and will break cacheing, please create an issue on github or message @zackpollard on telegram.");
                    break;
                }
                Voice voice = ((VoiceContent)messageResponse.getContent()).getContent();
                fileManager.cacheFileID(voiceMessage.getVoice().getFile(), voice.getFileId());
                break;
            }
            case LOCATION: {
                SendableLocationMessage locationMessage = (SendableLocationMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendLocation")).field("chat_id", (Object)chat.getId(), "application/json").field("latitude", (Object)locationMessage.getLatitude()).field("longitude", (Object)locationMessage.getLongitude());
                    Utils.processReplyContent(request, locationMessage);
                    Utils.processNotificationContent(request, locationMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = Utils.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                break;
            }
            case VENUE: {
                SendableVenueMessage venueMessage = (SendableVenueMessage)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendLocation")).field("chat_id", (Object)chat.getId(), "application/json").field("latitude", (Object)venueMessage.getLatitude()).field("longitude", (Object)venueMessage.getLongitude()).field("title", venueMessage.getTitle()).field("address", venueMessage.getAddress());
                    if (venueMessage.getFoursquareId() != null) {
                        request.field("foursquare_id", venueMessage.getFoursquareId());
                    }
                    Utils.processReplyContent(request, venueMessage);
                    Utils.processNotificationContent(request, venueMessage);
                    HttpResponse response = request.asString();
                    jsonResponse = Utils.processResponse((HttpResponse<String>)response);
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                break;
            }
            case CHAT_ACTION: {
                SendableChatAction sendableChatAction = (SendableChatAction)message;
                try {
                    MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "sendChatAction")).field("chat_id", (Object)chat.getId(), "application/json").field("action", sendableChatAction.getChatAction().getName());
                    HttpResponse response = request.asString();
                }
                catch (UnirestException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        return Utils.checkResponseStatus(jsonResponse) ? (messageResponse != null ? messageResponse : MessageImpl.createMessage(jsonResponse, this)) : null;
    }

    private JSONObject editMessageText(String chatId, Long messageId, String inlineMessageId, String text, ParseMode parseMode, boolean disableWebPagePreview, InlineReplyMarkup inlineReplyMarkup) {
        JSONObject jsonResponse = null;
        try {
            MultipartBody requests = Unirest.post((String)(this.getBotAPIUrl() + "editMessageText")).field("text", (Object)text, "application/json").field("disable_web_page_preview", (Object)disableWebPagePreview);
            if (chatId != null) {
                requests.field("chat_id", chatId, "application/json");
            }
            if (messageId != null) {
                requests.field("message_id", (Object)messageId);
            }
            if (inlineMessageId != null) {
                requests.field("inline_message_id", inlineMessageId, "application/json");
            }
            if (parseMode != null) {
                requests.field("parse_mode", parseMode.getModeName(), "application/json");
            }
            if (inlineReplyMarkup != null) {
                requests.field("reply_markup", GSON.toJson((Object)inlineReplyMarkup, InlineKeyboardMarkup.class), "application/json");
            }
            HttpResponse response = requests.asString();
            jsonResponse = Utils.processResponse((HttpResponse<String>)response);
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return jsonResponse;
    }

    public Message editMessageText(Message oldMessage, String text, ParseMode parseMode, boolean disableWebPagePreview, InlineReplyMarkup inlineReplyMarkup) {
        return this.editMessageText(oldMessage.getChat().getId(), oldMessage.getMessageId(), text, parseMode, disableWebPagePreview, inlineReplyMarkup);
    }

    public Message editMessageText(String chatId, Long messageId, String text, ParseMode parseMode, boolean disableWebPagePreview, InlineReplyMarkup inlineReplyMarkup) {
        JSONObject jsonResponse;
        if (chatId != null && messageId != null && text != null && (jsonResponse = this.editMessageText(chatId, messageId, null, text, parseMode, disableWebPagePreview, inlineReplyMarkup)) != null) {
            return MessageImpl.createMessage(jsonResponse.getJSONObject("result"), this);
        }
        return null;
    }

    public boolean editInlineMessageText(String inlineMessageId, String text, ParseMode parseMode, boolean disableWebPagePreview, InlineReplyMarkup inlineReplyMarkup) {
        JSONObject jsonResponse;
        return inlineMessageId != null && text != null && (jsonResponse = this.editMessageText(null, null, inlineMessageId, text, parseMode, disableWebPagePreview, inlineReplyMarkup)) != null && jsonResponse.getBoolean("result");
    }

    private JSONObject editMessageCaption(String chatId, Long messageId, String inlineMessageId, String caption, InlineReplyMarkup inlineReplyMarkup) {
        JSONObject jsonResponse = null;
        try {
            MultipartBody requests = Unirest.post((String)(this.getBotAPIUrl() + "editMessageCaption")).field("caption", (Object)caption, "application/json");
            if (chatId != null) {
                requests.field("chat_id", chatId, "application/json");
            }
            if (messageId != null) {
                requests.field("message_id", (Object)messageId);
            }
            if (inlineMessageId != null) {
                requests.field("inline_message_id", inlineMessageId, "application/json");
            }
            if (inlineReplyMarkup != null) {
                requests.field("reply_markup", GSON.toJson((Object)inlineReplyMarkup, InlineKeyboardMarkup.class), "application/json");
            }
            HttpResponse response = requests.asString();
            jsonResponse = Utils.processResponse((HttpResponse<String>)response);
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return jsonResponse;
    }

    public Message editMessageCaption(Message oldMessage, String caption, InlineReplyMarkup inlineReplyMarkup) {
        return this.editMessageCaption(oldMessage.getChat().getId(), oldMessage.getMessageId(), caption, inlineReplyMarkup);
    }

    public Message editMessageCaption(String chatId, Long messageId, String caption, InlineReplyMarkup inlineReplyMarkup) {
        JSONObject jsonResponse;
        if (caption != null && chatId != null && messageId != null && (jsonResponse = this.editMessageCaption(chatId, messageId, null, caption, inlineReplyMarkup)) != null) {
            return MessageImpl.createMessage(jsonResponse.getJSONObject("result"), this);
        }
        return null;
    }

    public boolean editInlineCaption(String inlineMessageId, String caption, InlineReplyMarkup inlineReplyMarkup) {
        JSONObject jsonResponse;
        return caption != null && inlineReplyMarkup != null && (jsonResponse = this.editMessageCaption(null, null, inlineMessageId, caption, inlineReplyMarkup)) != null && jsonResponse.getBoolean("result");
    }

    private JSONObject editMessageReplyMarkup(String chatId, Long messageId, String inlineMessageId, InlineReplyMarkup inlineReplyMarkup) {
        JSONObject jsonResponse = null;
        try {
            MultipartBody requests = Unirest.post((String)(this.getBotAPIUrl() + "editMessageReplyMarkup")).field("reply_markup", (Object)GSON.toJson((Object)inlineReplyMarkup, InlineKeyboardMarkup.class), "application/json");
            if (chatId != null) {
                requests.field("chat_id", chatId, "application/json");
            }
            if (messageId != null) {
                requests.field("message_id", (Object)messageId);
            }
            if (inlineMessageId != null) {
                requests.field("inline_message_id", inlineMessageId, "application/json");
            }
            HttpResponse response = requests.asString();
            jsonResponse = Utils.processResponse((HttpResponse<String>)response);
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return jsonResponse;
    }

    public Message editMessageReplyMarkup(Message oldMessage, InlineReplyMarkup inlineReplyMarkup) {
        return this.editMessageReplyMarkup(oldMessage.getChat().getId(), oldMessage.getMessageId(), inlineReplyMarkup);
    }

    public Message editMessageReplyMarkup(String chatId, Long messageId, InlineReplyMarkup inlineReplyMarkup) {
        JSONObject jsonResponse;
        if (inlineReplyMarkup != null && chatId != null && messageId != null && (jsonResponse = this.editMessageReplyMarkup(chatId, messageId, null, inlineReplyMarkup)) != null) {
            return MessageImpl.createMessage(jsonResponse.getJSONObject("result"), this);
        }
        return null;
    }

    public boolean editInlineMessageReplyMarkup(String inlineMessageId, InlineReplyMarkup inlineReplyMarkup) {
        JSONObject jsonResponse;
        return inlineMessageId != null && inlineReplyMarkup != null && (jsonResponse = this.editMessageReplyMarkup(null, null, inlineMessageId, inlineReplyMarkup)) != null && jsonResponse.getBoolean("result");
    }

    public boolean answerInlineQuery(String inlineQueryId, InlineQueryResponse inlineQueryResponse) {
        if (inlineQueryId != null && inlineQueryResponse != null) {
            try {
                MultipartBody requests = Unirest.post((String)(this.getBotAPIUrl() + "answerInlineQuery")).field("inline_query_id", (Object)inlineQueryId).field("results", GSON.toJson(inlineQueryResponse.getResults())).field("cache_time", (Object)inlineQueryResponse.getCacheTime()).field("is_personal", (Object)inlineQueryResponse.isPersonal()).field("next_offset", inlineQueryResponse.getNextOffset()).field("switch_pm_text", inlineQueryResponse.getSwitchPmText()).field("switch_pm_parameter", inlineQueryResponse.getSwitchPmParameter());
                HttpResponse response = requests.asString();
                JSONObject jsonResponse = Utils.processResponse((HttpResponse<String>)response);
                if (jsonResponse != null && jsonResponse.getBoolean("result")) {
                    return true;
                }
            }
            catch (UnirestException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean answerCallbackQuery(String callbackQueryId, String text, boolean showAlert) {
        if (callbackQueryId != null && text != null) {
            try {
                MultipartBody requests = Unirest.post((String)(this.getBotAPIUrl() + "answerCallbackQuery")).field("callback_query_id", (Object)callbackQueryId, "application/json").field("text", text, "application/json").field("show_alert", (Object)showAlert);
                HttpResponse response = requests.asString();
                JSONObject jsonResponse = Utils.processResponse((HttpResponse<String>)response);
                if (jsonResponse != null && jsonResponse.getBoolean("result")) {
                    return true;
                }
            }
            catch (UnirestException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean kickChatMember(String chatId, int userId) {
        try {
            MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "kickChatMember")).field("chat_id", (Object)chatId, "application/json").field("user_id", (Object)userId);
            HttpResponse response = request.asString();
            JSONObject jsonResponse = Utils.processResponse((HttpResponse<String>)response);
            if (jsonResponse != null && jsonResponse.getBoolean("result")) {
                return true;
            }
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean unbanChatMember(String chatId, int userId) {
        try {
            MultipartBody request = Unirest.post((String)(this.getBotAPIUrl() + "unbanChatMember")).field("chat_id", (Object)chatId, "application/json").field("user_id", (Object)userId);
            HttpResponse response = request.asString();
            JSONObject jsonResponse = Utils.processResponse((HttpResponse<String>)response);
            if (jsonResponse != null && jsonResponse.getBoolean("result")) {
                return true;
            }
        }
        catch (UnirestException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void startUpdates(boolean getPreviousUpdates) {
        this.updateManager = new RequestUpdatesManager(this, getPreviousUpdates);
    }

    public ListenerRegistry getEventsManager() {
        return this.listenerRegistry;
    }

    public static FileManager getFileManager() {
        return fileManager;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public int getBotID() {
        return this.botID;
    }

    public String getBotName() {
        return this.botName;
    }

    public String getBotUsername() {
        return this.botUsername;
    }
}

