/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.InlineReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContent;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultCachedAudio
implements InlineQueryResult {
    private final InlineQueryResultType type = InlineQueryResultType.AUDIO;
    @NonNull
    private final String id;
    @NonNull
    private final String audio_file_id;
    private final InlineReplyMarkup reply_markup;
    private final InputMessageContent input_message_content;

    public static InlineQueryResultCachedAudioBuilder builder() {
        return new InlineQueryResultCachedAudioBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    private String getAudioFileId() {
        return this.audio_file_id;
    }

    public InlineReplyMarkup getReplyMarkup() {
        return this.reply_markup;
    }

    public InputMessageContent getInputMessageContent() {
        return this.input_message_content;
    }

    public String toString() {
        return "InlineQueryResultCachedAudio(type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", audio_file_id=" + this.audio_file_id + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ")";
    }

    private InlineQueryResultCachedAudio(@NonNull String id, @NonNull String audio_file_id, InlineReplyMarkup reply_markup, InputMessageContent input_message_content) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (audio_file_id == null) {
            throw new NullPointerException("audio_file_id");
        }
        this.id = id;
        this.audio_file_id = audio_file_id;
        this.reply_markup = reply_markup;
        this.input_message_content = input_message_content;
    }

    public static class InlineQueryResultCachedAudioBuilder {
        private String id = Utils.generateRandomString(32);
        private String audio_file_id;
        private InlineReplyMarkup reply_markup;
        private InputMessageContent input_message_content;

        InlineQueryResultCachedAudioBuilder() {
        }

        public InlineQueryResultCachedAudioBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultCachedAudioBuilder audioFileId(String audioFileId) {
            this.audio_file_id = audioFileId;
            return this;
        }

        public InlineQueryResultCachedAudioBuilder replyMarkup(InlineReplyMarkup replyMarkup) {
            this.reply_markup = replyMarkup;
            return this;
        }

        public InlineQueryResultCachedAudioBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.input_message_content = inputMessageContent;
            return this;
        }

        public InlineQueryResultCachedAudio build() {
            return new InlineQueryResultCachedAudio(this.id, this.audio_file_id, this.reply_markup, this.input_message_content);
        }

        public String toString() {
            return "InlineQueryResultCachedAudio.InlineQueryResultCachedAudioBuilder(id=" + this.id + ", audio_file_id=" + this.audio_file_id + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ")";
        }
    }
}

