/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.chat.message.content.type;

import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.chat.message.content.type.Location;
import pro.zackpollard.telegrambot.api.chat.message.content.type.Venue;
import pro.zackpollard.telegrambot.api.internal.chat.message.content.type.LocationImpl;

public class VenueImpl
implements Venue {
    private final Location location;
    private final String title;
    private final String address;
    private final String foursquare_id;

    private VenueImpl(JSONObject jsonObject) {
        this.location = LocationImpl.createLocation(jsonObject.getJSONObject("location"));
        this.title = jsonObject.getString("title");
        this.address = jsonObject.getString("address");
        this.foursquare_id = jsonObject.optString("foursquare_id");
    }

    public static Venue createVenue(JSONObject jsonObject) {
        return jsonObject != null ? new VenueImpl(jsonObject) : null;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getFoursquareId() {
        return this.foursquare_id;
    }
}

