/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.conversations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.chat.Chat;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.content.Content;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;
import pro.zackpollard.telegrambot.api.conversations.ConversationContext;
import pro.zackpollard.telegrambot.api.conversations.ConversationPrompt;
import pro.zackpollard.telegrambot.api.utils.Utils;

public final class Conversation {
    private int promptIndex = 0;
    private final ConversationContext context;
    private final Chat forWhom;
    private boolean silent;
    private boolean disableGlobalEvents;
    private ConversationPrompt currentPrompt;
    private final List<ConversationPrompt> prompts;

    private Conversation(TelegramBot bot, Map<String, Object> sessionData, Chat forWhom, boolean silent, boolean disableGlobalEvents, List<ConversationPrompt> prompts) {
        this.forWhom = forWhom;
        this.context = new ConversationContext(this, bot, sessionData);
        this.currentPrompt = prompts.get(this.promptIndex);
        this.prompts = Collections.unmodifiableList(prompts);
        this.silent = silent;
        this.disableGlobalEvents = disableGlobalEvents;
    }

    public static ConversationBuilder builder(TelegramBot bot) {
        return new ConversationBuilder(bot);
    }

    public Conversation begin() {
        SendableMessage response;
        this.context.getBot().getConversationRegistry().registerConversation(this);
        if (!this.silent && (response = this.currentPrompt.promptMessage(this.context)) != null) {
            this.forWhom.sendMessage(response);
        }
        return this;
    }

    public void accept(Message message) {
        Content content = message.getContent();
        if (content.getType() != this.currentPrompt.type()) {
            return;
        }
        if (!this.currentPrompt.process(this.context, content)) {
            if (this.promptIndex + 1 == this.prompts.size()) {
                this.end();
                return;
            }
            this.currentPrompt = this.prompts.get(++this.promptIndex);
        }
        SendableMessage promptMessage = this.currentPrompt.promptMessage(this.context);
        if (!this.silent && promptMessage != null) {
            this.forWhom.sendMessage(promptMessage);
        }
        this.context.getHistory().history.add(message);
    }

    public void end() {
        if (this.currentPrompt != null) {
            this.currentPrompt.conversationEnded(this.context);
            this.currentPrompt = null;
        }
        this.context.getBot().getConversationRegistry().removeConversation(this);
    }

    public ConversationContext getContext() {
        return this.context;
    }

    public Chat getForWhom() {
        return this.forWhom;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setDisableGlobalEvents(boolean disableGlobalEvents) {
        this.disableGlobalEvents = disableGlobalEvents;
    }

    public boolean isDisableGlobalEvents() {
        return this.disableGlobalEvents;
    }

    public ConversationPrompt getCurrentPrompt() {
        return this.currentPrompt;
    }

    public List<ConversationPrompt> getPrompts() {
        return this.prompts;
    }

    public static class PromptsBuilder {
        private final List<ConversationPrompt> prompts = new ArrayList<ConversationPrompt>();
        private final ConversationBuilder conversationBuilder;

        private PromptsBuilder(ConversationBuilder conversationBuilder) {
            this.conversationBuilder = conversationBuilder;
        }

        public PromptsBuilder first(ConversationPrompt prompt) {
            this.prompts.clear();
            return this.then(prompt);
        }

        public PromptsBuilder then(ConversationPrompt prompt) {
            this.prompts.add(prompt);
            return this;
        }

        public ConversationBuilder last(ConversationPrompt prompt) {
            this.prompts.add(prompt);
            return this.end();
        }

        public ConversationBuilder end() {
            this.conversationBuilder.prompts = this.prompts;
            return this.conversationBuilder;
        }
    }

    public static class ConversationBuilder {
        private final TelegramBot bot;
        private Chat forWhom;
        private List<ConversationPrompt> prompts = null;
        private Map<String, Object> sessionData = new HashMap<String, Object>();
        private boolean silent;
        private boolean disableGlobalEvents;

        ConversationBuilder(TelegramBot bot) {
            this.bot = bot;
        }

        public ConversationBuilder forWhom(Chat chat) {
            this.forWhom = chat;
            return this;
        }

        public PromptsBuilder prompts() {
            return new PromptsBuilder(this);
        }

        public ConversationBuilder sessionData(Map<String, Object> data) {
            this.sessionData = data;
            return this;
        }

        public ConversationBuilder silent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public ConversationBuilder disableGlobalEvents(boolean disableGlobalEvents) {
            this.disableGlobalEvents = disableGlobalEvents;
            return this;
        }

        public Conversation build() {
            Utils.validateNotNull(this.bot, this.forWhom, this.prompts);
            return new Conversation(this.bot, this.sessionData, this.forWhom, this.silent, this.disableGlobalEvents, this.prompts);
        }
    }
}

