/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.updates;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.chat.inline.InlineCallbackQuery;
import pro.zackpollard.telegrambot.api.chat.message.MessageCallbackQuery;
import pro.zackpollard.telegrambot.api.chat.message.content.TextContent;
import pro.zackpollard.telegrambot.api.event.chat.CallbackQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.ChannelChatCreatedEvent;
import pro.zackpollard.telegrambot.api.event.chat.DeleteGroupChatPhotoEvent;
import pro.zackpollard.telegrambot.api.event.chat.GroupChatCreatedEvent;
import pro.zackpollard.telegrambot.api.event.chat.MigrateFromChatEvent;
import pro.zackpollard.telegrambot.api.event.chat.MigrateToChatEvent;
import pro.zackpollard.telegrambot.api.event.chat.NewGroupChatPhotoEvent;
import pro.zackpollard.telegrambot.api.event.chat.NewGroupChatTitleEvent;
import pro.zackpollard.telegrambot.api.event.chat.ParticipantJoinGroupChatEvent;
import pro.zackpollard.telegrambot.api.event.chat.ParticipantLeaveGroupChatEvent;
import pro.zackpollard.telegrambot.api.event.chat.SuperGroupChatCreatedEvent;
import pro.zackpollard.telegrambot.api.event.chat.inline.InlineCallbackQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.inline.InlineQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.inline.InlineResultChosenEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.AudioMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.CommandMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.ContactMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.DocumentMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.LocationMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.MessageCallbackQueryReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.MessageEditReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.MessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.PhotoMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.StickerMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.TextMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.VideoMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.event.chat.message.VoiceMessageReceivedEvent;
import pro.zackpollard.telegrambot.api.internal.event.ListenerRegistryImpl;
import pro.zackpollard.telegrambot.api.internal.updates.UpdateImpl;
import pro.zackpollard.telegrambot.api.updates.Update;
import pro.zackpollard.telegrambot.api.updates.UpdateManager;

public class RequestUpdatesManager
extends UpdateManager {
    private ListenerRegistryImpl eventManager = null;
    private Thread updaterThread = null;
    private boolean getPreviousUpdates = false;

    public RequestUpdatesManager(TelegramBot telegramBot, boolean getPreviousUpdates) {
        super(telegramBot);
        this.getPreviousUpdates = getPreviousUpdates;
    }

    @Override
    public boolean startUpdates() {
        if (this.eventManager == null) {
            this.eventManager = (ListenerRegistryImpl)this.getBotInstance().getEventsManager();
        }
        if (this.updaterThread == null && !this.running) {
            this.updaterThread = new Thread(new UpdaterRunnable(this.getPreviousUpdates));
            this.updaterThread.start();
            return true;
        }
        return false;
    }

    @Override
    public void stopUpdates() {
        this.running = false;
        this.updaterThread.interrupt();
    }

    private class UpdaterRunnable
    implements Runnable {
        private boolean getPreviousUpdates;

        protected UpdaterRunnable(boolean getPreviousUpdates) {
            this.getPreviousUpdates = getPreviousUpdates;
        }

        @Override
        public void run() {
            RequestUpdatesManager.this.running = true;
            int offset = 0;
            while (RequestUpdatesManager.this.running) {
                HttpResponse response = null;
                try {
                    response = Unirest.post((String)(RequestUpdatesManager.this.getBotInstance().getBotAPIUrl() + "getUpdates")).field("offset", (Object)(offset + 1), "application/json; charset=utf8;").field("timeout", (Object)10).asString();
                }
                catch (UnirestException e) {
                    System.err.println("There was a connection error when trying to retrieve updates, waiting for 1 second and then trying again.");
                    System.err.println(e.getLocalizedMessage());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                catch (JSONException e) {
                    System.err.println("There was a JSON error, suspected API error, waiting for 1 second and then trying again.");
                    System.err.println(e.getMessage());
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                }
                if (response != null && response.getStatus() == 200) {
                    JSONObject jsonResponse;
                    try {
                        jsonResponse = new JSONObject((String)response.getBody());
                    }
                    catch (JSONException e) {
                        System.err.println("API didn't return a JSON response. Response content was: " + (String)response.getBody());
                        continue;
                    }
                    if (jsonResponse.getBoolean("ok")) {
                        JSONArray updates = jsonResponse.getJSONArray("result");
                        if (updates.length() != 0) {
                            offset = updates.getJSONObject(updates.length() - 1).getInt("update_id");
                        }
                        if (!this.getPreviousUpdates) {
                            if (updates.length() >= 100) continue;
                            this.getPreviousUpdates = true;
                            continue;
                        }
                        for (int i = 0; i < updates.length(); ++i) {
                            Update update = UpdateImpl.createUpdate(updates.getJSONObject(i), RequestUpdatesManager.this.getBotInstance());
                            try {
                                block6 : switch (update.getType()) {
                                    case MESSAGE: {
                                        if (RequestUpdatesManager.this.getBotInstance().getConversationRegistry().processMessage(update.getMessage())) break;
                                        RequestUpdatesManager.this.eventManager.callEvent(new MessageReceivedEvent(update.getMessage()));
                                        switch (update.getMessage().getContent().getType()) {
                                            case AUDIO: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new AudioMessageReceivedEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case CONTACT: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new ContactMessageReceivedEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case DELETE_CHAT_PHOTO: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new DeleteGroupChatPhotoEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case DOCUMENT: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new DocumentMessageReceivedEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case LOCATION: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new LocationMessageReceivedEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case NEW_CHAT_TITLE: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new NewGroupChatTitleEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case NEW_CHAT_PARTICIPANT: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new ParticipantJoinGroupChatEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case PHOTO: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new PhotoMessageReceivedEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case STICKER: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new StickerMessageReceivedEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case TEXT: {
                                                if (((TextContent)update.getMessage().getContent()).getContent().startsWith("/")) {
                                                    RequestUpdatesManager.this.eventManager.callEvent(new CommandMessageReceivedEvent(update.getMessage()));
                                                    break block6;
                                                }
                                                RequestUpdatesManager.this.eventManager.callEvent(new TextMessageReceivedEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case VIDEO: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new VideoMessageReceivedEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case VOICE: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new VoiceMessageReceivedEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case GROUP_CHAT_CREATED: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new GroupChatCreatedEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case LEFT_CHAT_PARTICIPANT: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new ParticipantLeaveGroupChatEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case NEW_CHAT_PHOTO: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new NewGroupChatPhotoEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case CHANNEL_CHAT_CREATED: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new ChannelChatCreatedEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case MIGRATE_FROM_CHAT_ID: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new MigrateFromChatEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case MIGRATE_TO_CHAT_ID: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new MigrateToChatEvent(update.getMessage()));
                                                break block6;
                                            }
                                            case SUPER_GROUP_CHAT_CREATED: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new SuperGroupChatCreatedEvent(update.getMessage()));
                                            }
                                        }
                                        break;
                                    }
                                    case EDITED_MESSAGE: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new MessageEditReceivedEvent(update.getEditedMessage()));
                                        break;
                                    }
                                    case INLINE_QUERY: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new InlineQueryReceivedEvent(update.getInlineQuery()));
                                        break;
                                    }
                                    case CHOSEN_INLINE_RESULT: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new InlineResultChosenEvent(update.getChosenInlineResult()));
                                        break;
                                    }
                                    case CALLBACK_QUERY: {
                                        RequestUpdatesManager.this.eventManager.callEvent(new CallbackQueryReceivedEvent(update.getCallbackQuery()));
                                        switch (update.getCallbackQuery().getType()) {
                                            case MESSAGE: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new MessageCallbackQueryReceivedEvent((MessageCallbackQuery)update.getCallbackQuery()));
                                                break block6;
                                            }
                                            case INLINE_MESSAGE: {
                                                RequestUpdatesManager.this.eventManager.callEvent(new InlineCallbackQueryReceivedEvent((InlineCallbackQuery)update.getCallbackQuery()));
                                            }
                                        }
                                    }
                                }
                                continue;
                            }
                            catch (Exception e) {
                                System.err.println("An error occurred during an event, check the stacktrace below for a more detailed error.");
                                e.printStackTrace();
                            }
                        }
                    } else {
                        System.err.println("The API returned the following error: " + jsonResponse.getString("description"));
                    }
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

