/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import java.net.URL;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.InlineReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContent;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultPhoto
implements InlineQueryResult {
    private final InlineQueryResultType type = InlineQueryResultType.PHOTO;
    @NonNull
    private final String id;
    @NonNull
    private final URL photo_url;
    private final int photo_width;
    private final int photo_height;
    @NonNull
    private final URL thumb_url;
    private final String title;
    private final String description;
    private final String caption;
    private final InlineReplyMarkup reply_markup;
    private final InputMessageContent input_message_content;

    public static InlineQueryResultPhotoBuilder builder() {
        return new InlineQueryResultPhotoBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public URL getPhotoUrl() {
        return this.photo_url;
    }

    public int getPhotoWidth() {
        return this.photo_width;
    }

    public int getPhotoHeight() {
        return this.photo_height;
    }

    @NonNull
    public URL getThumbUrl() {
        return this.thumb_url;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public InputMessageContent getInputMessageContent() {
        return this.input_message_content;
    }

    public String getDescription() {
        return this.description;
    }

    public InlineReplyMarkup getReplyMarkup() {
        return this.reply_markup;
    }

    public String toString() {
        return "InlineQueryResultPhoto(type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", photo_url=" + this.photo_url + ", photo_width=" + this.photo_width + ", photo_height=" + this.photo_height + ", thumb_url=" + this.thumb_url + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", caption=" + this.getCaption() + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ")";
    }

    private InlineQueryResultPhoto(@NonNull String id, @NonNull URL photo_url, int photo_width, int photo_height, @NonNull URL thumb_url, String title, String description, String caption, InlineReplyMarkup reply_markup, InputMessageContent input_message_content) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (photo_url == null) {
            throw new NullPointerException("photo_url");
        }
        if (thumb_url == null) {
            throw new NullPointerException("thumb_url");
        }
        this.id = id;
        this.photo_url = photo_url;
        this.photo_width = photo_width;
        this.photo_height = photo_height;
        this.thumb_url = thumb_url;
        this.title = title;
        this.description = description;
        this.caption = caption;
        this.reply_markup = reply_markup;
        this.input_message_content = input_message_content;
    }

    public static class InlineQueryResultPhotoBuilder {
        private String id = Utils.generateRandomString(32);
        private URL photo_url;
        private int photo_width;
        private int photo_height;
        private URL thumb_url;
        private String title;
        private String description;
        private String caption;
        private InlineReplyMarkup reply_markup;
        private InputMessageContent input_message_content;

        InlineQueryResultPhotoBuilder() {
        }

        public InlineQueryResultPhotoBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultPhotoBuilder photoUrl(URL photoUrl) {
            this.photo_url = photoUrl;
            return this;
        }

        public InlineQueryResultPhotoBuilder photoWidth(int photoWidth) {
            this.photo_width = photoWidth;
            return this;
        }

        public InlineQueryResultPhotoBuilder photoHeight(int photoHeight) {
            this.photo_height = photoHeight;
            return this;
        }

        public InlineQueryResultPhotoBuilder thumbUrl(URL thumbUrl) {
            this.thumb_url = thumbUrl;
            return this;
        }

        public InlineQueryResultPhotoBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InlineQueryResultPhotoBuilder description(String description) {
            this.description = description;
            return this;
        }

        public InlineQueryResultPhotoBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public InlineQueryResultPhotoBuilder replyMarkup(InlineReplyMarkup replyMarkup) {
            this.reply_markup = replyMarkup;
            return this;
        }

        public InlineQueryResultPhotoBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.input_message_content = inputMessageContent;
            return this;
        }

        public InlineQueryResultPhoto build() {
            return new InlineQueryResultPhoto(this.id, this.photo_url, this.photo_width, this.photo_height, this.thumb_url, this.title, this.description, this.caption, this.reply_markup, this.input_message_content);
        }

        public String toString() {
            return "InlineQueryResultPhoto.InlineQueryResultPhotoBuilder(id=" + this.id + ", photo_url=" + this.photo_url + ", photo_width=" + this.photo_width + ", photo_height=" + this.photo_height + ", thumb_url=" + this.thumb_url + ", title=" + this.title + ", description=" + this.description + ", caption=" + this.caption + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ")";
        }
    }
}

