/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.message.send;

import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.ReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.message.send.MessageType;
import pro.zackpollard.telegrambot.api.chat.message.send.NotificationOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.ReplyingOptions;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SendableVenueMessage
implements SendableMessage,
ReplyingOptions,
NotificationOptions {
    @NonNull
    private final double latitude;
    @NonNull
    private final double longitude;
    @NonNull
    private final String title;
    @NonNull
    private final String address;
    private final String foursquareId;
    private final long replyTo;
    private final ReplyMarkup replyMarkup;
    private final boolean disableNotification;

    public static SendableVenueMessageBuilder builder() {
        return new SendableVenueMessageBuilder();
    }

    @Override
    public MessageType getType() {
        return MessageType.VENUE;
    }

    public String toString() {
        return "SendableVenueMessage(latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", title=" + this.getTitle() + ", address=" + this.getAddress() + ", foursquareId=" + this.getFoursquareId() + ", replyTo=" + this.getReplyTo() + ", replyMarkup=" + this.getReplyMarkup() + ", disableNotification=" + this.isDisableNotification() + ")";
    }

    private SendableVenueMessage(@NonNull double latitude, @NonNull double longitude, @NonNull String title, @NonNull String address, String foursquareId, long replyTo, ReplyMarkup replyMarkup, boolean disableNotification) {
        if (title == null) {
            throw new NullPointerException("title");
        }
        if (address == null) {
            throw new NullPointerException("address");
        }
        this.latitude = latitude;
        this.longitude = longitude;
        this.title = title;
        this.address = address;
        this.foursquareId = foursquareId;
        this.replyTo = replyTo;
        this.replyMarkup = replyMarkup;
        this.disableNotification = disableNotification;
    }

    @NonNull
    public double getLatitude() {
        return this.latitude;
    }

    @NonNull
    public double getLongitude() {
        return this.longitude;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public String getAddress() {
        return this.address;
    }

    public String getFoursquareId() {
        return this.foursquareId;
    }

    @Override
    public long getReplyTo() {
        return this.replyTo;
    }

    @Override
    public ReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    @Override
    public boolean isDisableNotification() {
        return this.disableNotification;
    }

    public static class SendableVenueMessageBuilder {
        private double latitude;
        private double longitude;
        private String title;
        private String address;
        private String foursquareId;
        private long replyTo;
        private ReplyMarkup replyMarkup;
        private boolean disableNotification;

        SendableVenueMessageBuilder() {
        }

        public SendableVenueMessageBuilder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public SendableVenueMessageBuilder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public SendableVenueMessageBuilder title(String title) {
            this.title = title;
            return this;
        }

        public SendableVenueMessageBuilder address(String address) {
            this.address = address;
            return this;
        }

        public SendableVenueMessageBuilder foursquareId(String foursquareId) {
            this.foursquareId = foursquareId;
            return this;
        }

        public SendableVenueMessageBuilder replyTo(Message replyTo) {
            this.replyTo = replyTo != null ? replyTo.getMessageId() : 0L;
            return this;
        }

        public SendableVenueMessageBuilder replyTo(long replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public SendableVenueMessageBuilder replyMarkup(ReplyMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        public SendableVenueMessageBuilder disableNotification(boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        public SendableVenueMessage build() {
            return new SendableVenueMessage(this.latitude, this.longitude, this.title, this.address, this.foursquareId, this.replyTo, this.replyMarkup, this.disableNotification);
        }

        public String toString() {
            return "SendableVenueMessage.SendableVenueMessageBuilder(latitude=" + this.latitude + ", longitude=" + this.longitude + ", title=" + this.title + ", address=" + this.address + ", foursquareId=" + this.foursquareId + ", replyTo=" + this.replyTo + ", replyMarkup=" + this.replyMarkup + ", disableNotification=" + this.disableNotification + ")";
        }
    }
}

