/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.conversations;

import java.util.Map;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.chat.Chat;
import pro.zackpollard.telegrambot.api.conversations.Conversation;
import pro.zackpollard.telegrambot.api.conversations.ConversationHistory;

public final class ConversationContext {
    private final ConversationHistory history = ConversationHistory.create();
    private final Conversation conversation;
    private final Chat from;
    private final TelegramBot bot;
    private final Map<String, Object> conversationData;

    ConversationContext(Conversation conversation, TelegramBot bot, Map<String, Object> conversationData) {
        this.conversation = conversation;
        this.from = conversation.getForWhom();
        this.bot = bot;
        this.conversationData = conversationData;
    }

    public Object sessionDataBy(String key) {
        return this.conversationData.get(key);
    }

    public void setSessionData(String key, Object value) {
        this.conversationData.put(key, value);
    }

    public boolean hasDataBy(String key) {
        return this.conversationData.containsKey(key);
    }

    public ConversationHistory getHistory() {
        return this.history;
    }

    public Conversation getConversation() {
        return this.conversation;
    }

    public Chat getFrom() {
        return this.from;
    }

    public TelegramBot getBot() {
        return this.bot;
    }
}

