/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.conversations.prompt;

import java.util.regex.Pattern;
import pro.zackpollard.telegrambot.api.chat.message.content.TextContent;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;
import pro.zackpollard.telegrambot.api.conversations.ConversationContext;
import pro.zackpollard.telegrambot.api.conversations.prompt.TextValidatingPrompt;

public abstract class NumericPrompt
extends TextValidatingPrompt {
    private static final Pattern INTEGER_PATTERN = Pattern.compile("^[1-9]{1,10}$");
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("^[1-9]{1,309}\\.[1-9]{1,2}$");
    private static final Pattern FLOAT_PATTERN = Pattern.compile("^[1-9]{1,29}\\.[1-9]{3,9}$");

    @Override
    protected boolean validate(ConversationContext context, TextContent input) {
        Number number = this.parseNumber(input.getContent());
        return number != null && this.validateNumber(context, number);
    }

    @Override
    protected SendableMessage invalidationMessage(ConversationContext context, TextContent input) {
        return this.parseNumber(input.getContent()) == null ? this.notNumericMessage(context, input) : this.invalidInputMessage(context, input);
    }

    @Override
    protected boolean accept(ConversationContext context, TextContent input) {
        return this.accept(context, this.parseNumber(input.getContent()));
    }

    protected Number parseNumber(String text) {
        if (INTEGER_PATTERN.matcher(text).matches()) {
            return Integer.parseInt(text);
        }
        if (DOUBLE_PATTERN.matcher(text).matches()) {
            return Double.parseDouble(text);
        }
        if (FLOAT_PATTERN.matcher(text).matches()) {
            return Float.valueOf(Float.parseFloat(text));
        }
        return null;
    }

    protected abstract boolean validateNumber(ConversationContext var1, Number var2);

    protected abstract boolean accept(ConversationContext var1, Number var2);

    protected abstract SendableMessage invalidInputMessage(ConversationContext var1, TextContent var2);

    protected abstract SendableMessage notNumericMessage(ConversationContext var1, TextContent var2);
}

