/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.keyboards;

import lombok.NonNull;

public class KeyboardButton {
    @NonNull
    private final String text;
    private final boolean request_contact;
    private final boolean request_location;

    public static KeyboardButtonBuilder builder() {
        return new KeyboardButtonBuilder();
    }

    public String getText() {
        return this.text;
    }

    public boolean isRequestContact() {
        return this.request_contact;
    }

    public boolean isRequestLocation() {
        return this.request_location;
    }

    public String toString() {
        return "KeyboardButton(text=" + this.getText() + ", request_contact=" + this.request_contact + ", request_location=" + this.request_location + ")";
    }

    private KeyboardButton(@NonNull String text, boolean request_contact, boolean request_location) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        this.text = text;
        this.request_contact = request_contact;
        this.request_location = request_location;
    }

    public static class KeyboardButtonBuilder {
        private String text;
        private boolean request_contact = false;
        private boolean request_location = false;

        KeyboardButtonBuilder() {
        }

        public KeyboardButtonBuilder text(String text) {
            this.text = text;
            return this;
        }

        public KeyboardButtonBuilder requestContact(boolean requestContact) {
            this.request_contact = requestContact;
            if (requestContact) {
                this.request_location = false;
            }
            return this;
        }

        public KeyboardButtonBuilder requestLocation(boolean requestLocation) {
            this.request_location = requestLocation;
            if (requestLocation) {
                this.request_contact = false;
            }
            return this;
        }

        public KeyboardButton build() {
            return new KeyboardButton(this.text, this.request_contact, this.request_location);
        }

        public String toString() {
            return "KeyboardButton.KeyboardButtonBuilder(text=" + this.text + ", request_contact=" + this.request_contact + ", request_location=" + this.request_location + ")";
        }
    }
}

