/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.menu.button;

import pro.zackpollard.telegrambot.api.keyboards.InlineKeyboardButton;
import pro.zackpollard.telegrambot.api.menu.InlineMenu;
import pro.zackpollard.telegrambot.api.menu.button.InlineMenuButton;
import pro.zackpollard.telegrambot.api.menu.button.callback.ButtonCallback;

public abstract class AbstractInlineMenuButton
implements InlineMenuButton {
    protected ButtonCallback buttonCallback;
    protected String text;
    protected final int row;
    protected final int num;
    protected InlineMenu owner;

    protected AbstractInlineMenuButton(InlineMenu owner, int row, int num) {
        this.owner = owner;
        this.row = row;
        this.num = num;
    }

    protected AbstractInlineMenuButton(InlineMenu owner, int row, int num, String text) {
        this(owner, row, num);
        this.text = text;
    }

    @Override
    public InlineMenu getMenu() {
        return this.owner;
    }

    @Override
    public void setText(String text) {
        if (text != null) {
            this.text = text;
            this.owner.apply();
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public ButtonCallback getCallback() {
        return this.buttonCallback;
    }

    @Override
    public InlineMenuButton setCallback(ButtonCallback callback) {
        this.buttonCallback = callback;
        return this;
    }

    @Override
    public void assignMenu(InlineMenu owner) {
        this.owner = owner;
    }

    protected InlineKeyboardButton.InlineKeyboardButtonBuilder keyboardBuilder() {
        return InlineKeyboardButton.builder().text(this.text).callbackData("im." + this.owner.getInternalId() + "." + this.row + "." + this.num);
    }

    public int getRow() {
        return this.row;
    }

    public int getNum() {
        return this.num;
    }

    public InlineMenu getOwner() {
        return this.owner;
    }

    public void setOwner(InlineMenu owner) {
        this.owner = owner;
    }
}

