/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.menu.button.impl;

import java.util.function.BiConsumer;
import pro.zackpollard.telegrambot.api.chat.CallbackQuery;
import pro.zackpollard.telegrambot.api.chat.message.content.TextContent;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;
import pro.zackpollard.telegrambot.api.conversations.Conversation;
import pro.zackpollard.telegrambot.api.conversations.ConversationContext;
import pro.zackpollard.telegrambot.api.conversations.prompt.TextPrompt;
import pro.zackpollard.telegrambot.api.keyboards.InlineKeyboardButton;
import pro.zackpollard.telegrambot.api.menu.InlineMenu;
import pro.zackpollard.telegrambot.api.menu.button.AbstractInlineMenuButton;
import pro.zackpollard.telegrambot.api.menu.button.InlineMenuButton;

public class UserInputInlineMenuButton
extends AbstractInlineMenuButton {
    private final BiConsumer<InlineMenuButton, String> textCallback;
    private boolean inputGiven = true;

    public UserInputInlineMenuButton(InlineMenu owner, int row, int num, String text, BiConsumer<InlineMenuButton, String> textCallback) {
        super(owner, row, num, text);
        this.textCallback = textCallback;
    }

    public UserInputInlineMenuButton(InlineMenu owner, int row, int num, BiConsumer<InlineMenuButton, String> textCallback) {
        super(owner, row, num);
        this.textCallback = textCallback;
    }

    @Override
    public InlineKeyboardButton toKeyboardButton() {
        return this.keyboardBuilder().build();
    }

    @Override
    public void handlePress(CallbackQuery query) {
        this.executeCallback();
        if (this.textCallback != null && this.inputGiven) {
            this.inputGiven = false;
            Conversation.builder(query.getBotInstance()).forWhom(this.owner.getBaseMessage().getChat()).silent(true).prompts().last(new TextPrompt(){

                @Override
                public boolean process(ConversationContext context, TextContent input) {
                    UserInputInlineMenuButton.this.textCallback.accept(UserInputInlineMenuButton.this, input.getContent());
                    UserInputInlineMenuButton.this.inputGiven = true;
                    return false;
                }

                @Override
                public SendableMessage promptMessage(ConversationContext context) {
                    return null;
                }
            }).build().begin();
        }
    }

    public BiConsumer<InlineMenuButton, String> getTextCallback() {
        return this.textCallback;
    }
}

