/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import java.net.URL;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.InlineReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContent;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultDocument
implements InlineQueryResult {
    private final InlineQueryResultType type = InlineQueryResultType.DOCUMENT;
    @NonNull
    private final String id;
    @NonNull
    private final String title;
    private final String caption;
    @NonNull
    private final URL document_url;
    @NonNull
    private final String mime_type;
    private final String description;
    private final InlineReplyMarkup reply_markup;
    private final InputMessageContent input_message_content;
    private final URL thumb_url;
    private final Integer thumb_width;
    private final Integer thumb_height;

    public static InlineQueryResultDocumentBuilder builder() {
        return new InlineQueryResultDocumentBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    @NonNull
    public URL getDocumentUrl() {
        return this.document_url;
    }

    @NonNull
    public String getMimeType() {
        return this.mime_type;
    }

    public String getDescription() {
        return this.description;
    }

    public InlineReplyMarkup getReplyMarkup() {
        return this.reply_markup;
    }

    public InputMessageContent getInputMessageContent() {
        return this.input_message_content;
    }

    public URL getThumbUrl() {
        return this.thumb_url;
    }

    public int getThumbWidth() {
        return this.thumb_width;
    }

    public int getThumbHeight() {
        return this.thumb_height;
    }

    public String toString() {
        return "InlineQueryResultDocument(type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", title=" + this.getTitle() + ", caption=" + this.getCaption() + ", document_url=" + this.document_url + ", mime_type=" + this.mime_type + ", description=" + this.getDescription() + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ", thumb_url=" + this.thumb_url + ", thumb_width=" + this.thumb_width + ", thumb_height=" + this.thumb_height + ")";
    }

    private InlineQueryResultDocument(@NonNull String id, @NonNull String title, String caption, @NonNull URL document_url, @NonNull String mime_type, String description, InlineReplyMarkup reply_markup, InputMessageContent input_message_content, URL thumb_url, Integer thumb_width, Integer thumb_height) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (title == null) {
            throw new NullPointerException("title");
        }
        if (document_url == null) {
            throw new NullPointerException("document_url");
        }
        if (mime_type == null) {
            throw new NullPointerException("mime_type");
        }
        this.id = id;
        this.title = title;
        this.caption = caption;
        this.document_url = document_url;
        this.mime_type = mime_type;
        this.description = description;
        this.reply_markup = reply_markup;
        this.input_message_content = input_message_content;
        this.thumb_url = thumb_url;
        this.thumb_width = thumb_width;
        this.thumb_height = thumb_height;
    }

    public static class InlineQueryResultDocumentBuilder {
        private String id = Utils.generateRandomString(32);
        private String title;
        private String caption;
        private URL document_url;
        private String mime_type;
        private String description;
        private InlineReplyMarkup reply_markup;
        private InputMessageContent input_message_content;
        private URL thumb_url;
        private Integer thumb_width;
        private Integer thumb_height;

        InlineQueryResultDocumentBuilder() {
        }

        public InlineQueryResultDocumentBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultDocumentBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InlineQueryResultDocumentBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public InlineQueryResultDocumentBuilder documentUrl(URL documentUrl) {
            this.document_url = documentUrl;
            return this;
        }

        public InlineQueryResultDocumentBuilder mimeType(String mimeType) {
            this.mime_type = mimeType;
            return this;
        }

        public InlineQueryResultDocumentBuilder description(String description) {
            this.description = description;
            return this;
        }

        public InlineQueryResultDocumentBuilder replyMarkup(InlineReplyMarkup replyMarkup) {
            this.reply_markup = replyMarkup;
            return this;
        }

        public InlineQueryResultDocumentBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.input_message_content = inputMessageContent;
            return this;
        }

        public InlineQueryResultDocumentBuilder thumbUrl(URL thumbUrl) {
            this.thumb_url = thumbUrl;
            return this;
        }

        public InlineQueryResultDocumentBuilder thumbWidth(int thumbWidth) {
            this.thumb_width = thumbWidth;
            return this;
        }

        public InlineQueryResultDocumentBuilder thumbHeight(int thumbHeight) {
            this.thumb_height = thumbHeight;
            return this;
        }

        public InlineQueryResultDocument build() {
            return new InlineQueryResultDocument(this.id, this.title, this.caption, this.document_url, this.mime_type, this.description, this.reply_markup, this.input_message_content, this.thumb_url, this.thumb_width, this.thumb_height);
        }

        public String toString() {
            return "InlineQueryResultDocument.InlineQueryResultDocumentBuilder(id=" + this.id + ", title=" + this.title + ", caption=" + this.caption + ", document_url=" + this.document_url + ", mime_type=" + this.mime_type + ", description=" + this.description + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ", thumb_url=" + this.thumb_url + ", thumb_width=" + this.thumb_width + ", thumb_height=" + this.thumb_height + ")";
        }
    }
}

