/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.chat;

import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.chat.GroupChat;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class GroupChatImpl
implements GroupChat {
    private final int id;
    private final String title;
    private final TelegramBot telegramBot;

    private GroupChatImpl(JSONObject jsonObject, TelegramBot telegramBot) {
        this.id = jsonObject.getInt("id");
        this.title = jsonObject.getString("title");
        this.telegramBot = telegramBot;
    }

    private GroupChatImpl(int chatID, TelegramBot telegramBot) {
        this.id = chatID;
        this.title = null;
        this.telegramBot = telegramBot;
    }

    public static GroupChat createGroupChat(JSONObject jsonObject, TelegramBot telegramBot) {
        return new GroupChatImpl(jsonObject, telegramBot);
    }

    public static GroupChat createGroupChat(int chatID, TelegramBot telegramBot) {
        return new GroupChatImpl(chatID, telegramBot);
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public TelegramBot getBotInstance() {
        return this.telegramBot;
    }

    @Override
    public String getId() {
        return String.valueOf(this.id);
    }

    @Override
    public Message sendMessage(SendableMessage message) {
        return this.telegramBot.sendMessage(this, message);
    }

    @Override
    public boolean kickChatMember(int userId) {
        return this.telegramBot.kickChatMember(this.getId(), userId);
    }
}

