/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.content;

import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContent;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContentType;

public class InputVenueMessageContent
implements InputMessageContent {
    @NonNull
    private final double latitude;
    @NonNull
    private final double longitude;
    @NonNull
    private final String title;
    @NonNull
    private final String address;
    private final String foursquare_id;

    public static InputVenueMessageContentBuilder builder() {
        return new InputVenueMessageContentBuilder();
    }

    @NonNull
    public double getLatitude() {
        return this.latitude;
    }

    @NonNull
    public double getLongitude() {
        return this.longitude;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public String getAddress() {
        return this.address;
    }

    public String getFoursquareId() {
        return this.foursquare_id;
    }

    @Override
    public InputMessageContentType getType() {
        return InputMessageContentType.VENUE;
    }

    public String toString() {
        return "InputVenueMessageContent(latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", title=" + this.getTitle() + ", address=" + this.getAddress() + ", foursquare_id=" + this.foursquare_id + ")";
    }

    private InputVenueMessageContent(@NonNull double latitude, @NonNull double longitude, @NonNull String title, @NonNull String address, String foursquare_id) {
        if (title == null) {
            throw new NullPointerException("title");
        }
        if (address == null) {
            throw new NullPointerException("address");
        }
        this.latitude = latitude;
        this.longitude = longitude;
        this.title = title;
        this.address = address;
        this.foursquare_id = foursquare_id;
    }

    public static class InputVenueMessageContentBuilder {
        private double latitude;
        private double longitude;
        private String title;
        private String address;
        private String foursquare_id;

        InputVenueMessageContentBuilder() {
        }

        public InputVenueMessageContentBuilder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public InputVenueMessageContentBuilder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public InputVenueMessageContentBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InputVenueMessageContentBuilder address(String address) {
            this.address = address;
            return this;
        }

        public InputVenueMessageContentBuilder foursquareId(String foursquareId) {
            this.foursquare_id = foursquareId;
            return this;
        }

        public InputVenueMessageContent build() {
            return new InputVenueMessageContent(this.latitude, this.longitude, this.title, this.address, this.foursquare_id);
        }

        public String toString() {
            return "InputVenueMessageContent.InputVenueMessageContentBuilder(latitude=" + this.latitude + ", longitude=" + this.longitude + ", title=" + this.title + ", address=" + this.address + ", foursquare_id=" + this.foursquare_id + ")";
        }
    }
}

