/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.chat.inline.send.results;

import java.net.URL;
import lombok.NonNull;
import pro.zackpollard.telegrambot.api.chat.inline.InlineReplyMarkup;
import pro.zackpollard.telegrambot.api.chat.inline.send.content.InputMessageContent;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResult;
import pro.zackpollard.telegrambot.api.chat.inline.send.results.InlineQueryResultType;
import pro.zackpollard.telegrambot.api.utils.Utils;

public class InlineQueryResultAudio
implements InlineQueryResult {
    private final InlineQueryResultType type = InlineQueryResultType.AUDIO;
    @NonNull
    private final String id;
    @NonNull
    private final URL audio_url;
    @NonNull
    private final String title;
    private final String performer;
    private final Integer audio_duration;
    private final InlineReplyMarkup reply_markup;
    private final InputMessageContent input_message_content;
    private final String caption;

    public static InlineQueryResultAudioBuilder builder() {
        return new InlineQueryResultAudioBuilder();
    }

    @Override
    public InlineQueryResultType getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public URL getAudioUrl() {
        return this.audio_url;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getPerformer() {
        return this.performer;
    }

    public int getAudioDuration() {
        return this.audio_duration;
    }

    public InlineReplyMarkup getReplyMarkup() {
        return this.reply_markup;
    }

    public InputMessageContent getInputMessageContent() {
        return this.input_message_content;
    }

    public String toString() {
        return "InlineQueryResultAudio(type=" + (Object)((Object)this.getType()) + ", id=" + this.getId() + ", audio_url=" + this.audio_url + ", title=" + this.getTitle() + ", performer=" + this.getPerformer() + ", audio_duration=" + this.audio_duration + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ", caption=" + this.getCaption() + ")";
    }

    private InlineQueryResultAudio(@NonNull String id, @NonNull URL audio_url, @NonNull String title, String performer, Integer audio_duration, InlineReplyMarkup reply_markup, InputMessageContent input_message_content, String caption) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (audio_url == null) {
            throw new NullPointerException("audio_url");
        }
        if (title == null) {
            throw new NullPointerException("title");
        }
        this.id = id;
        this.audio_url = audio_url;
        this.title = title;
        this.performer = performer;
        this.audio_duration = audio_duration;
        this.reply_markup = reply_markup;
        this.input_message_content = input_message_content;
        this.caption = caption;
    }

    public static class InlineQueryResultAudioBuilder {
        private String id = Utils.generateRandomString(32);
        private URL audio_url;
        private String title;
        private String performer;
        private Integer audio_duration;
        private InlineReplyMarkup reply_markup;
        private InputMessageContent input_message_content;
        private String caption;

        InlineQueryResultAudioBuilder() {
        }

        public InlineQueryResultAudioBuilder id(String id) {
            this.id = id;
            return this;
        }

        public InlineQueryResultAudioBuilder audioUrl(URL audioUrl) {
            this.audio_url = audioUrl;
            return this;
        }

        public InlineQueryResultAudioBuilder title(String title) {
            this.title = title;
            return this;
        }

        public InlineQueryResultAudioBuilder performer(String performer) {
            this.performer = performer;
            return this;
        }

        public InlineQueryResultAudioBuilder audioDuration(Integer audioDuration) {
            this.audio_duration = audioDuration;
            return this;
        }

        public InlineQueryResultAudioBuilder replyMarkup(InlineReplyMarkup replyMarkup) {
            this.reply_markup = replyMarkup;
            return this;
        }

        public InlineQueryResultAudioBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.input_message_content = inputMessageContent;
            return this;
        }

        public InlineQueryResultAudioBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public InlineQueryResultAudio build() {
            return new InlineQueryResultAudio(this.id, this.audio_url, this.title, this.performer, this.audio_duration, this.reply_markup, this.input_message_content, this.caption);
        }

        public String toString() {
            return "InlineQueryResultAudio.InlineQueryResultAudioBuilder(id=" + this.id + ", audio_url=" + this.audio_url + ", title=" + this.title + ", performer=" + this.performer + ", audio_duration=" + this.audio_duration + ", reply_markup=" + this.reply_markup + ", input_message_content=" + this.input_message_content + ", caption=" + this.caption + ")";
        }
    }
}

