/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.conversations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.chat.Chat;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.content.Content;
import pro.zackpollard.telegrambot.api.chat.message.content.TextContent;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableTextMessage;
import pro.zackpollard.telegrambot.api.conversations.ConversationContext;
import pro.zackpollard.telegrambot.api.conversations.ConversationPrompt;
import pro.zackpollard.telegrambot.api.user.User;
import pro.zackpollard.telegrambot.api.utils.Utils;

public final class Conversation {
    private static final Timer TIMER = new Timer();
    private int promptIndex = 0;
    private final ConversationContext context;
    private final Chat forWhom;
    private boolean silent;
    private boolean disableGlobalEvents;
    private ConversationPrompt currentPrompt;
    private boolean virgin = true;
    private final List<ConversationPrompt> prompts;
    private final Predicate<User> userPredicate;
    private final boolean repliesOnly;
    private final BiConsumer<Conversation, ConversationContext> endCallback;
    private final BiPredicate<ConversationContext, Content> endPredicate;

    private Conversation(TelegramBot bot, Map<String, Object> sessionData, Chat forWhom, boolean silent, boolean disableGlobalEvents, List<ConversationPrompt> prompts, Predicate<User> userPredicate, boolean repliesOnly, BiConsumer<Conversation, ConversationContext> endCallback, BiPredicate<ConversationContext, Content> endPredicate, long timeout, final SendableMessage timeoutMessage) {
        this.forWhom = forWhom;
        this.context = new ConversationContext(this, bot, sessionData);
        this.currentPrompt = prompts.get(this.promptIndex);
        this.prompts = Collections.unmodifiableList(prompts);
        this.silent = silent;
        this.disableGlobalEvents = disableGlobalEvents;
        this.userPredicate = userPredicate == null ? user -> true : userPredicate;
        this.repliesOnly = repliesOnly;
        this.endCallback = endCallback;
        this.endPredicate = endPredicate;
        if (timeout > 0L) {
            TIMER.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (Conversation.this.isVirgin()) {
                        if (timeoutMessage != null) {
                            Conversation.this.sendMessage(timeoutMessage);
                        }
                        Conversation.this.end();
                    }
                }
            }, TimeUnit.SECONDS.toMillis(timeout));
        }
    }

    public static ConversationBuilder builder(TelegramBot bot) {
        return new ConversationBuilder(bot);
    }

    public Conversation begin() {
        SendableMessage response;
        if (!this.virgin) {
            throw new IllegalStateException("You can only start a virgin conversation!");
        }
        this.context.getBot().getConversationRegistry().registerConversation(this);
        if (!this.silent && (response = this.currentPrompt.promptMessage(this.context)) != null) {
            this.sendMessage(response);
        }
        return this;
    }

    public boolean accept(Message message) {
        Message repliedTo;
        Content content = message.getContent();
        if (!this.userPredicate.test(message.getSender())) {
            return false;
        }
        if (this.endPredicate != null && this.endPredicate.test(this.context, content)) {
            this.end();
            return true;
        }
        if (content.getType() != this.currentPrompt.type()) {
            return false;
        }
        if (this.repliesOnly && ((repliedTo = message.getRepliedTo()) == null || repliedTo.getSender().getUsername().equals(this.context.getBot().getBotUsername()))) {
            return false;
        }
        if (!this.currentPrompt.process(this.context, content)) {
            if (this.promptIndex + 1 == this.prompts.size()) {
                this.end();
                return true;
            }
            this.currentPrompt = this.prompts.get(++this.promptIndex);
        }
        SendableMessage promptMessage = this.currentPrompt.promptMessage(this.context);
        if (!this.silent && promptMessage != null) {
            this.sendMessage(promptMessage);
        }
        this.context.getHistory().history.add(message);
        return true;
    }

    public void end() {
        if (this.endCallback != null) {
            this.endCallback.accept(this, this.context);
        }
        if (this.currentPrompt != null) {
            this.currentPrompt.conversationEnded(this.context);
            this.currentPrompt = null;
        }
        this.context.getBot().getConversationRegistry().removeConversation(this);
        this.virgin = false;
    }

    private void sendMessage(SendableMessage message) {
        this.context.getHistory().sentMessages.add(this.forWhom.sendMessage(message).getMessageId());
    }

    public ConversationContext getContext() {
        return this.context;
    }

    public Chat getForWhom() {
        return this.forWhom;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setDisableGlobalEvents(boolean disableGlobalEvents) {
        this.disableGlobalEvents = disableGlobalEvents;
    }

    public boolean isDisableGlobalEvents() {
        return this.disableGlobalEvents;
    }

    public ConversationPrompt getCurrentPrompt() {
        return this.currentPrompt;
    }

    public boolean isVirgin() {
        return this.virgin;
    }

    public List<ConversationPrompt> getPrompts() {
        return this.prompts;
    }

    public static class PromptsBuilder {
        private final List<ConversationPrompt> prompts = new ArrayList<ConversationPrompt>();
        private final ConversationBuilder conversationBuilder;

        private PromptsBuilder(ConversationBuilder conversationBuilder) {
            this.conversationBuilder = conversationBuilder;
        }

        public PromptsBuilder first(ConversationPrompt prompt) {
            this.prompts.clear();
            return this.then(prompt);
        }

        public PromptsBuilder then(ConversationPrompt prompt) {
            this.prompts.add(prompt);
            return this;
        }

        public ConversationBuilder last(ConversationPrompt prompt) {
            this.prompts.add(prompt);
            return this.end();
        }

        public ConversationBuilder end() {
            this.conversationBuilder.prompts = this.prompts;
            return this.conversationBuilder;
        }
    }

    public static class ConversationBuilder {
        private final TelegramBot bot;
        private Chat forWhom;
        private List<ConversationPrompt> prompts = null;
        private Map<String, Object> sessionData = new HashMap<String, Object>();
        private boolean silent;
        private boolean disableGlobalEvents;
        private boolean repliesOnly = false;
        private Predicate<User> userPredicate;
        private BiConsumer<Conversation, ConversationContext> endCallback;
        private BiPredicate<ConversationContext, Content> endPredicate;
        private long timeout = -1L;
        private SendableMessage timeoutMessage;

        ConversationBuilder(TelegramBot bot) {
            this.bot = bot;
        }

        public ConversationBuilder conservationTimeout(long timeout) {
            return this.conversationTimeout(timeout, null);
        }

        public ConversationBuilder conversationTimeout(long timeout, SendableMessage message) {
            this.timeout = timeout;
            this.timeoutMessage = message;
            return this;
        }

        public ConversationBuilder endCommand(String command) {
            return this.endText(command.charAt(0) == '/' ? command : "/" + command);
        }

        public ConversationBuilder endText(String text) {
            return this.endText(text, true);
        }

        public ConversationBuilder endText(String text, boolean ignoreCase) {
            return this.endText((String string2) -> ignoreCase ? text.equalsIgnoreCase((String)string2) : text.equals(string2));
        }

        public ConversationBuilder endText(Predicate<String> textPredicate) {
            return this.endPredicate((context, content) -> content instanceof TextContent && textPredicate.test(((TextContent)content).getContent()));
        }

        public ConversationBuilder endPredicate(BiPredicate<ConversationContext, Content> predicate) {
            this.endPredicate = predicate;
            return this;
        }

        public ConversationBuilder endingMessage(SendableTextMessage message) {
            return this.endCallback((conv, context) -> ((Conversation)conv).sendMessage(message));
        }

        public ConversationBuilder endCallback(BiConsumer<Conversation, ConversationContext> callback) {
            this.endCallback = callback;
            return this;
        }

        public ConversationBuilder forWhom(Chat chat) {
            this.forWhom = chat;
            return this;
        }

        public PromptsBuilder prompts() {
            return new PromptsBuilder(this);
        }

        public ConversationBuilder sessionData(Map<String, Object> data) {
            this.sessionData = data;
            return this;
        }

        public ConversationBuilder silent(boolean silent) {
            this.silent = silent;
            return this;
        }

        public ConversationBuilder disableGlobalEvents(boolean disableGlobalEvents) {
            this.disableGlobalEvents = disableGlobalEvents;
            return this;
        }

        public ConversationBuilder repliesOnly(boolean value) {
            this.repliesOnly = value;
            return this;
        }

        public ConversationBuilder userFilter(Predicate<User> predicate) {
            this.userPredicate = predicate;
            return this;
        }

        public ConversationBuilder allowedUsers(User ... users) {
            List<User> usersList = Arrays.asList(users);
            this.userPredicate = user -> usersList.stream().anyMatch(allowedUser -> allowedUser.getId() == user.getId());
            return this;
        }

        public ConversationBuilder allowedUser(User allowedUser) {
            this.userPredicate = user2 -> user2.getId() == allowedUser.getId();
            return this;
        }

        public ConversationBuilder allowedUsers(long ... userIds) {
            this.userPredicate = user -> {
                for (long id : userIds) {
                    if (id != user.getId()) continue;
                    return true;
                }
                return false;
            };
            return this;
        }

        public ConversationBuilder allowedUser(long userId) {
            this.userPredicate = user -> user.getId() == userId;
            return this;
        }

        public Conversation build() {
            Utils.validateNotNull(this.bot, this.forWhom, this.prompts);
            return new Conversation(this.bot, this.sessionData, this.forWhom, this.silent, this.disableGlobalEvents, this.prompts, this.userPredicate, this.repliesOnly, this.endCallback, this.endPredicate, this.timeout, this.timeoutMessage);
        }
    }
}

