/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.chat;

import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.chat.SuperGroupChat;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableMessage;

public class SuperGroupChatImpl
implements SuperGroupChat {
    private final long id;
    private final String username;
    private final String title;
    private final TelegramBot telegramBot;

    private SuperGroupChatImpl(JSONObject jsonObject, TelegramBot telegramBot) {
        this.id = jsonObject.getLong("id");
        this.username = "@" + jsonObject.optString("username");
        this.title = jsonObject.getString("title");
        this.telegramBot = telegramBot;
    }

    private SuperGroupChatImpl(long chatID, TelegramBot telegramBot) {
        this.id = chatID;
        this.title = null;
        this.username = null;
        this.telegramBot = telegramBot;
    }

    public static SuperGroupChat createSuperGroupChat(JSONObject jsonObject, TelegramBot telegramBot) {
        return new SuperGroupChatImpl(jsonObject, telegramBot);
    }

    public static SuperGroupChat createSuperGroupChat(long chatID, TelegramBot telegramBot) {
        return new SuperGroupChatImpl(chatID, telegramBot);
    }

    @Override
    public String getName() {
        return this.title;
    }

    @Override
    public TelegramBot getBotInstance() {
        return this.telegramBot;
    }

    @Override
    public String getId() {
        return String.valueOf(this.id);
    }

    @Override
    public Message sendMessage(SendableMessage message) {
        return this.telegramBot.sendMessage(this, message);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean kickChatMember(int userId) {
        return this.telegramBot.kickChatMember(this.getId(), userId);
    }

    @Override
    public boolean unbanChatMember(int userId) {
        return this.telegramBot.unbanChatMember(this.getId(), userId);
    }
}

