/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.chat.message.content.type;

import org.json.JSONObject;
import pro.zackpollard.telegrambot.api.chat.message.content.type.Document;
import pro.zackpollard.telegrambot.api.chat.message.content.type.PhotoSize;
import pro.zackpollard.telegrambot.api.internal.chat.message.content.type.PhotoSizeImpl;

public class DocumentImpl
implements Document {
    private final String file_id;
    private final PhotoSize thumb;
    private final String file_name;
    private final String mime_type;
    private final int file_size;

    private DocumentImpl(JSONObject jsonObject) {
        this.file_id = jsonObject.getString("file_id");
        this.thumb = PhotoSizeImpl.createPhotoSize(jsonObject.optJSONObject("thumb"));
        this.file_name = jsonObject.optString("file_name");
        this.mime_type = jsonObject.optString("mime_type");
        this.file_size = jsonObject.optInt("file_size");
    }

    public static Document createDocument(JSONObject jsonObject) {
        return jsonObject != null ? new DocumentImpl(jsonObject) : null;
    }

    @Override
    public String getFileId() {
        return this.file_id;
    }

    @Override
    public int getSize() {
        return this.file_size;
    }

    @Override
    public String getMimeType() {
        return this.mime_type;
    }

    @Override
    public PhotoSize getThumbnail() {
        return this.thumb;
    }

    @Override
    public String getFileName() {
        return this.file_name;
    }
}

