/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.internal.conversations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.conversations.Conversation;
import pro.zackpollard.telegrambot.api.conversations.ConversationRegistry;

public class ConversationRegistryImpl
implements ConversationRegistry {
    private final Map<String, List<Conversation>> activeConversations = new HashMap<String, List<Conversation>>();

    private ConversationRegistryImpl() {
    }

    public static ConversationRegistry create() {
        return new ConversationRegistryImpl();
    }

    @Override
    public void registerConversation(Conversation conversation) {
        String id = conversation.getForWhom().getId();
        if (!this.activeConversations.containsKey(id)) {
            this.activeConversations.put(id, new ArrayList());
        }
        this.activeConversations.get(id).add(conversation);
    }

    @Override
    public void removeConversation(Conversation conversation) {
        String id = conversation.getForWhom().getId();
        if (this.activeConversations.containsKey(id)) {
            this.activeConversations.get(id).remove(conversation);
        }
        if (conversation.getCurrentPrompt() != null) {
            conversation.end();
        }
    }

    @Override
    public boolean processMessage(Message message) {
        List<Conversation> conversations = this.activeConversations.get(message.getChat().getId());
        if (conversations == null) {
            return false;
        }
        boolean disableEvents = false;
        for (Conversation conversation : conversations) {
            if (conversation.getCurrentPrompt().type() != message.getContent().getType() && !disableEvents) {
                disableEvents = conversation.isDisableGlobalEvents();
            }
            if (!conversation.accept(message)) continue;
            return true;
        }
        return false;
    }
}

