/*
 * Decompiled with CFR 0.152.
 */
package pro.zackpollard.telegrambot.api.menu;

import java.util.List;
import java.util.function.Predicate;
import pro.zackpollard.telegrambot.api.TelegramBot;
import pro.zackpollard.telegrambot.api.chat.CallbackQuery;
import pro.zackpollard.telegrambot.api.chat.Chat;
import pro.zackpollard.telegrambot.api.chat.message.Message;
import pro.zackpollard.telegrambot.api.chat.message.send.SendableTextMessage;
import pro.zackpollard.telegrambot.api.keyboards.InlineKeyboardMarkup;
import pro.zackpollard.telegrambot.api.menu.InlineMenuBuilder;
import pro.zackpollard.telegrambot.api.menu.InlineMenuRegistry;
import pro.zackpollard.telegrambot.api.menu.InlineMenuRow;
import pro.zackpollard.telegrambot.api.user.User;

public class InlineMenu {
    private int internalId;
    Message baseMessage;
    private InlineMenu parent;
    Predicate<User> userPredicate;
    List<InlineMenuRow> rows;

    InlineMenu(Message baseMessage) {
        this.baseMessage = baseMessage;
    }

    public static InlineMenuBuilder builder(TelegramBot bot) {
        return new InlineMenuBuilder(bot);
    }

    public static InlineMenuBuilder builder(TelegramBot bot, Chat forWhom) {
        return new InlineMenuBuilder(bot).forWhom(forWhom);
    }

    public void start() {
        this.apply();
        this.baseMessage.getBotInstance().getInlineMenuRegistry().register(this);
    }

    public void unregister() {
        this.baseMessage.getBotInstance().getInlineMenuRegistry().unregister(this);
    }

    public InlineMenuRow rowAt(int index) {
        return this.rows.get(index);
    }

    public InlineKeyboardMarkup toKeyboard() {
        InlineKeyboardMarkup.InlineKeyboardMarkupBuilder builder = InlineKeyboardMarkup.builder();
        if (this.rows.isEmpty()) {
            return null;
        }
        this.rows.stream().map(InlineMenuRow::toButtons).forEach(builder::addRow);
        return builder.build();
    }

    public boolean handle(CallbackQuery query, int row, int button) {
        if (!InlineMenu.validateCaller(InlineMenuRegistry.class)) {
            throw new UnsupportedOperationException("Invalid caller! Caller must implement InlineMenuRegistry");
        }
        return (this.userPredicate == null || this.userPredicate.test(query.getFrom())) && row < this.rows.size() && this.rowAt(row).handle(query, button);
    }

    public void apply() {
        this.baseMessage.getBotInstance().editMessageReplyMarkup(this.baseMessage, this.toKeyboard());
    }

    public void setMessageText(SendableTextMessage.SendableTextMessageBuilder messageBuilder) {
        SendableTextMessage message = messageBuilder.build();
        this.baseMessage.getBotInstance().editMessageText(this.baseMessage, message.getMessage(), message.getParseMode(), message.isDisableWebPagePreview(), this.toKeyboard());
    }

    public void setInternalId(int newId) {
        if (!InlineMenu.validateCaller(InlineMenuRegistry.class)) {
            throw new UnsupportedOperationException("Invalid caller! Caller must implement InlineMenuRegistry");
        }
        this.internalId = newId;
    }

    private static boolean validateCaller(Class<?> intendedClass) {
        Class<?> callingClass;
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        String rawFQN = stElements[3].toString().split("\\(")[0];
        try {
            callingClass = Class.forName(rawFQN.substring(0, rawFQN.lastIndexOf(46)));
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        return intendedClass.isAssignableFrom(callingClass);
    }

    public int getInternalId() {
        return this.internalId;
    }

    public Message getBaseMessage() {
        return this.baseMessage;
    }

    public InlineMenu getParent() {
        return this.parent;
    }

    public void setParent(InlineMenu parent) {
        this.parent = parent;
    }
}

