/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cert.redscan.utils.datalake;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.michelin.cert.redscan.utils.datalake.DatalakeStorage;
import com.michelin.cert.redscan.utils.datalake.DatalakeStorageException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kong.unirest.json.JSONArray;
import kong.unirest.json.JSONObject;
import org.apache.logging.log4j.LogManager;

public abstract class DatalakeStorageItem {
    @JsonIgnore
    private static final String BLOCK_INDEX = "blocklist";
    @JsonIgnore
    protected String index = null;
    protected String parent = null;
    protected boolean blocked;
    protected Map<String, Object> data;
    @JsonFormat(pattern="yyyy-MM-dd kk:mm")
    private Date lastScanDate;
    @JsonIgnore
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd kk:mm");

    public boolean create() throws DatalakeStorageException {
        boolean result = DatalakeStorage.createObject(this);
        if (this.getBlocked()) {
            result &= this.block();
        }
        return result &= this.upsert();
    }

    public abstract boolean upsert() throws DatalakeStorageException;

    public boolean delete() throws DatalakeStorageException {
        boolean result = true;
        if (this.isBlocked()) {
            result &= this.unblock();
        }
        return result &= DatalakeStorage.deleteObject(this);
    }

    public boolean upsertField(String key, Object value) throws DatalakeStorageException {
        return DatalakeStorage.upsertObjectField(this, key, value);
    }

    public boolean removeField(String key) throws DatalakeStorageException {
        return DatalakeStorage.removeObjectField(this, key);
    }

    public <T extends DatalakeStorageItem> List<T> findAll() throws DatalakeStorageException {
        ArrayList<T> datalakeStorageItems = new ArrayList<T>();
        JSONObject datalakeObject = this.findAllContent();
        if (datalakeObject != null) {
            int nbHits = datalakeObject.getJSONObject("total").getInt("value");
            JSONArray hits = datalakeObject.getJSONArray("hits");
            for (int i = 0; i < nbHits; ++i) {
                datalakeStorageItems.add(this.fromDatalake(hits.getJSONObject(i).getJSONObject("_source")));
            }
        }
        return datalakeStorageItems;
    }

    public <T extends DatalakeStorageItem> List<T> findAll(String page, String size) throws DatalakeStorageException {
        ArrayList<T> datalakeStorageItems = new ArrayList<T>();
        JSONObject datalakeObject = this.findAllContent(page, size);
        if (datalakeObject != null) {
            int nbHits = datalakeObject.getJSONObject("total").getInt("value");
            JSONArray hits = datalakeObject.getJSONArray("hits");
            for (int i = 0; i < nbHits; ++i) {
                datalakeStorageItems.add(this.fromDatalake(hits.getJSONObject(i).getJSONObject("_source")));
            }
        }
        return datalakeStorageItems;
    }

    public <T extends DatalakeStorageItem> List<T> findAll(String sort) throws DatalakeStorageException {
        ArrayList<T> datalakeStorageItems = new ArrayList<T>();
        JSONObject datalakeObject = this.findAllContent(new JSONObject(sort));
        if (datalakeObject != null) {
            int nbHits = datalakeObject.getJSONObject("total").getInt("value");
            JSONArray hits = datalakeObject.getJSONArray("hits");
            for (int i = 0; i < nbHits; ++i) {
                datalakeStorageItems.add(this.fromDatalake(hits.getJSONObject(i).getJSONObject("_source")));
            }
        }
        return datalakeStorageItems;
    }

    public <T extends DatalakeStorageItem> List<T> findAll(String sort, String page, String size) throws DatalakeStorageException {
        ArrayList<T> datalakeStorageItems = new ArrayList<T>();
        JSONObject datalakeObject = this.findAllContent(new JSONObject(sort), page, size);
        if (datalakeObject != null) {
            int nbHits = datalakeObject.getJSONObject("total").getInt("value");
            JSONArray hits = datalakeObject.getJSONArray("hits");
            for (int i = 0; i < nbHits; ++i) {
                datalakeStorageItems.add(this.fromDatalake(hits.getJSONObject(i).getJSONObject("_source")));
            }
        }
        return datalakeStorageItems;
    }

    protected JSONObject findAllContent() throws DatalakeStorageException {
        return DatalakeStorage.getObjects(this, null);
    }

    protected JSONObject findAllContent(JSONObject sort) throws DatalakeStorageException {
        return DatalakeStorage.getObjects(this, null, sort);
    }

    public JSONObject findAllContent(String page, String size) throws DatalakeStorageException {
        return DatalakeStorage.getObjects(this, null, page, size);
    }

    public JSONObject findAllContent(JSONObject sort, String page, String size) throws DatalakeStorageException {
        return DatalakeStorage.getObjects(this, null, page, size, sort);
    }

    public <T extends DatalakeStorageItem> T find() throws DatalakeStorageException {
        return this.find(this.getId());
    }

    public <T extends DatalakeStorageItem> T find(String id) throws DatalakeStorageException {
        JSONObject jsonObject = this.findContent(id);
        T result = this.fromDatalake(jsonObject);
        if (result != null) {
            ((DatalakeStorageItem)result).setData(jsonObject.toMap());
        }
        return result;
    }

    public <T extends DatalakeStorageItem> List<T> search(JSONObject query) throws DatalakeStorageException {
        ArrayList<T> datalakeStorageItems = new ArrayList<T>();
        JSONObject datalakeObject = this.searchContent(query);
        if (datalakeObject != null) {
            int nbHits = datalakeObject.getJSONObject("total").getInt("value");
            JSONArray hits = datalakeObject.getJSONArray("hits");
            for (int i = 0; i < nbHits; ++i) {
                datalakeStorageItems.add(this.fromDatalake(hits.getJSONObject(i).getJSONObject("_source")));
            }
        }
        return datalakeStorageItems;
    }

    public <T extends DatalakeStorageItem> List<T> search(JSONObject query, String sort) throws DatalakeStorageException {
        ArrayList<T> datalakeStorageItems = new ArrayList<T>();
        JSONObject datalakeObject = this.searchContent(query, new JSONObject(sort));
        if (datalakeObject != null) {
            int nbHits = datalakeObject.getJSONObject("total").getInt("value");
            JSONArray hits = datalakeObject.getJSONArray("hits");
            for (int i = 0; i < nbHits; ++i) {
                datalakeStorageItems.add(this.fromDatalake(hits.getJSONObject(i).getJSONObject("_source")));
            }
        }
        return datalakeStorageItems;
    }

    public <T extends DatalakeStorageItem> List<T> search(String page, String size, JSONObject query) throws DatalakeStorageException {
        ArrayList<T> datalakeStorageItems = new ArrayList<T>();
        JSONObject datalakeObject = this.searchContent(query, page, size);
        if (datalakeObject != null) {
            int nbHits = datalakeObject.getJSONObject("total").getInt("value");
            JSONArray hits = datalakeObject.getJSONArray("hits");
            for (int i = 0; i < nbHits; ++i) {
                datalakeStorageItems.add(this.fromDatalake(hits.getJSONObject(i).getJSONObject("_source")));
            }
        }
        return datalakeStorageItems;
    }

    public <T extends DatalakeStorageItem> List<T> search(String page, String size, JSONObject query, String sort) throws DatalakeStorageException {
        ArrayList<T> datalakeStorageItems = new ArrayList<T>();
        JSONObject datalakeObject = this.searchContent(query, page, size, new JSONObject(sort));
        if (datalakeObject != null) {
            int nbHits = datalakeObject.getJSONObject("total").getInt("value");
            JSONArray hits = datalakeObject.getJSONArray("hits");
            for (int i = 0; i < nbHits; ++i) {
                datalakeStorageItems.add(this.fromDatalake(hits.getJSONObject(i).getJSONObject("_source")));
            }
        }
        return datalakeStorageItems;
    }

    protected JSONObject findContent(String id) throws DatalakeStorageException {
        return id == null ? DatalakeStorage.getObject(this) : DatalakeStorage.getObject(this, id);
    }

    protected JSONObject searchContent(JSONObject query) throws DatalakeStorageException {
        return DatalakeStorage.getObjects(this, query);
    }

    protected JSONObject searchContent(JSONObject query, JSONObject sort) throws DatalakeStorageException {
        return DatalakeStorage.getObjects(this, query, sort);
    }

    protected JSONObject searchContent(JSONObject query, String page, String size) throws DatalakeStorageException {
        return DatalakeStorage.getObjects(this, query, page, size);
    }

    protected JSONObject searchContent(JSONObject query, String page, String size, JSONObject sort) throws DatalakeStorageException {
        return DatalakeStorage.getObjects(this, query, page, size, sort);
    }

    public abstract String getId();

    public String getBlockId() {
        return this.index + "@" + this.getId();
    }

    public boolean isBlocked() throws DatalakeStorageException {
        return DatalakeStorage.getObject(BLOCK_INDEX, this.getBlockId()) != null;
    }

    public boolean block() throws DatalakeStorageException {
        this.setBlocked(true);
        boolean result = this.upsert();
        return result &= DatalakeStorage.createObject(BLOCK_INDEX, this.getBlockId());
    }

    public boolean unblock() throws DatalakeStorageException {
        this.setBlocked(false);
        boolean result = this.upsert();
        return result &= DatalakeStorage.deleteObject(BLOCK_INDEX, this.getBlockId());
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public boolean getBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public Date getLastScanDate() {
        return this.lastScanDate;
    }

    public void setLastScanDate(Date lastScanDate) {
        this.lastScanDate = lastScanDate;
    }

    public static Date toDate(String str) {
        Date date = null;
        if (str != null && !str.isEmpty()) {
            try {
                date = sdf.parse(str);
            }
            catch (ParseException ex) {
                LogManager.getLogger(DatalakeStorageItem.class).error(ex.getMessage());
            }
        }
        return date;
    }

    public static String fromDate(Date date) {
        return date != null ? sdf.format(date) : null;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    protected abstract <T extends DatalakeStorageItem> T fromDatalake(JSONObject var1);
}

