/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cert.redscan.utils.models;

import com.michelin.cert.redscan.utils.datalake.DatalakeStorageException;
import com.michelin.cert.redscan.utils.datalake.DatalakeStorageItem;
import com.michelin.cert.redscan.utils.json.JsonUtils;
import com.michelin.cert.redscan.utils.models.Sendable;
import java.io.Serializable;
import java.util.Date;
import kong.unirest.json.JSONObject;

public class Brand
extends DatalakeStorageItem
implements Sendable,
Serializable {
    private String name;
    private int serviceLevel;

    public Brand() {
        this.index = "brands";
        this.parent = null;
    }

    public Brand(String name) {
        this();
        this.name = name;
    }

    public Brand(String name, int serviceLevel, Date lastScanDate) {
        this(name);
        this.serviceLevel = serviceLevel;
        this.setLastScanDate(lastScanDate);
    }

    @Override
    public String toJson() {
        JSONObject jsonObject = new JSONObject();
        JsonUtils.setSafeString(jsonObject, "name", this.name);
        JsonUtils.setSafeInt(jsonObject, "serviceLevel", this.serviceLevel);
        return jsonObject.toString();
    }

    @Override
    public void fromJson(String json) {
        JSONObject jsonObject = new JSONObject(json);
        this.name = JsonUtils.getSafeString(jsonObject, "name");
        this.serviceLevel = JsonUtils.getSafeInt(jsonObject, "serviceLevel");
    }

    @Override
    public <T extends DatalakeStorageItem> T fromDatalake(JSONObject object) {
        return (T)(object == null ? null : new Brand(JsonUtils.getSafeString(object, "name"), JsonUtils.getSafeInt(object, "serviceLevel"), Brand.toDate(JsonUtils.getSafeString(object, "last_scan_date"))));
    }

    @Override
    public boolean upsert() throws DatalakeStorageException {
        boolean result;
        boolean bl = result = this.find() != null;
        if (result) {
            result &= this.upsertField("name", this.name);
            result &= this.upsertField("serviceLevel", this.serviceLevel);
            result &= this.upsertField("last_scan_date", Brand.fromDate(this.getLastScanDate()));
        }
        return result;
    }

    @Override
    public String getFanoutExchangeName() {
        return "com.michelin.cert.fanout.brands";
    }

    @Override
    public String getId() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getServiceLevel() {
        return this.serviceLevel;
    }

    public void setServiceLevel(int serviceLevel) {
        this.serviceLevel = serviceLevel;
    }
}

