/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cert.redscan.utils.models;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.michelin.cert.redscan.utils.datalake.DatalakeStorageException;
import com.michelin.cert.redscan.utils.datalake.DatalakeStorageItem;
import com.michelin.cert.redscan.utils.json.JsonUtils;
import com.michelin.cert.redscan.utils.models.Sendable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kong.unirest.json.JSONObject;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.logging.log4j.LogManager;

public class IpRange
extends DatalakeStorageItem
implements Sendable,
Serializable {
    private String cidr;
    private int serviceLevel;
    private String description;
    @JsonFormat(pattern="yyyy-MM-dd kk:mm")
    private Date lastScanDate;

    public IpRange() {
        this.index = "iprange";
        this.parent = null;
    }

    public IpRange(String cidr) {
        this();
        this.cidr = cidr;
    }

    public IpRange(String cidr, String description, int serviceLevel, Date lastScanDate) {
        this(cidr);
        this.description = description;
        this.serviceLevel = serviceLevel;
        this.lastScanDate = lastScanDate;
    }

    public boolean isValid() {
        boolean result = false;
        try {
            new SubnetUtils(this.cidr);
            result = true;
        }
        catch (IllegalArgumentException ex) {
            LogManager.getLogger(IpRange.class).info(String.format("not valid (%s) : %s", this.cidr, ex.getMessage()));
        }
        return result;
    }

    public List<String> toIpList() {
        ArrayList<String> ips = new ArrayList<String>();
        try {
            String broadcastAddress;
            SubnetUtils subnetUtils = new SubnetUtils(this.cidr);
            Collections.addAll(ips, subnetUtils.getInfo().getAllAddresses());
            String networkAddress = subnetUtils.getInfo().getNetworkAddress();
            if (!ips.contains(networkAddress)) {
                ips.add(networkAddress);
            }
            if (!ips.contains(broadcastAddress = subnetUtils.getInfo().getBroadcastAddress())) {
                ips.add(broadcastAddress);
            }
        }
        catch (IllegalArgumentException ex) {
            LogManager.getLogger(IpRange.class).error(String.format("IllegalArgumentException (%s) : %s", this.cidr, ex.getMessage()));
            ips = null;
        }
        return ips;
    }

    public String getCidr() {
        return this.cidr;
    }

    public void setCidr(String cidr) {
        this.cidr = cidr;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Date getLastScanDate() {
        return this.lastScanDate;
    }

    @Override
    public void setLastScanDate(Date lastScanDate) {
        this.lastScanDate = lastScanDate;
    }

    public int getServiceLevel() {
        return this.serviceLevel;
    }

    public void setServiceLevel(int serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    @Override
    protected <T extends DatalakeStorageItem> T fromDatalake(JSONObject object) {
        return (T)(object == null ? null : new IpRange(JsonUtils.getSafeString(object, "cidr"), JsonUtils.getSafeString(object, "description"), JsonUtils.getSafeInt(object, "serviceLevel"), IpRange.toDate(JsonUtils.getSafeString(object, "last_scan_date"))));
    }

    @Override
    public boolean upsert() throws DatalakeStorageException {
        boolean result;
        boolean bl = result = this.find() != null;
        if (result) {
            result &= this.upsertField("cidr", this.cidr);
            result &= this.upsertField("description", this.description);
            result &= this.upsertField("serviceLevel", this.serviceLevel);
            result &= this.upsertField("last_scan_date", IpRange.fromDate(this.lastScanDate));
        }
        return result;
    }

    @Override
    public String getId() {
        return this.cidr.replace("/", "_");
    }

    @Override
    public String toJson() {
        JSONObject jsonObject = new JSONObject();
        JsonUtils.setSafeString(jsonObject, "cidr", this.cidr);
        JsonUtils.setSafeInt(jsonObject, "serviceLevel", this.serviceLevel);
        return jsonObject.toString();
    }

    @Override
    public void fromJson(String json) {
        JSONObject jsonObject = new JSONObject(json);
        this.cidr = JsonUtils.getSafeString(jsonObject, "cidr");
        this.serviceLevel = JsonUtils.getSafeInt(jsonObject, "serviceLevel");
    }

    @Override
    public String getFanoutExchangeName() {
        return "com.michelin.cert.fanout.iprange";
    }
}

