/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cert.redscan.utils.models.services;

import com.michelin.cert.redscan.utils.datalake.DatalakeStorageException;
import com.michelin.cert.redscan.utils.datalake.DatalakeStorageItem;
import com.michelin.cert.redscan.utils.json.JsonUtils;
import com.michelin.cert.redscan.utils.models.Sendable;
import kong.unirest.json.JSONObject;

public class Service
extends DatalakeStorageItem
implements Sendable {
    private String domain;
    private String ip;
    private String port;
    private String name;
    private String tunnel;
    private String banner;
    private String protocol;
    private String state;
    private String product;
    private String version;

    public Service() {
        this.index = "services";
    }

    public Service(String domain, String ip, String port) {
        this();
        this.domain = domain;
        this.ip = ip;
        this.port = port;
    }

    public Service(String domain, String ip, String port, String protocol) {
        this();
        this.domain = domain;
        this.ip = ip;
        this.port = port;
        this.protocol = protocol;
    }

    public Service(String domain, String ip, String port, String protocol, String parent) {
        this(domain, ip, port, protocol);
        this.parent = parent;
    }

    public Service(String domain, String ip, String port, String name, String tunnel, String protocol, String state, String product, String version, String parent) {
        this(domain, ip, port, protocol, parent);
        this.name = name;
        this.tunnel = tunnel;
        this.state = state;
        this.product = product;
        this.version = version;
    }

    @Override
    public String getId() {
        return String.format("%s_%s_%s", this.domain, this.port, this.protocol);
    }

    @Override
    public String toJson() {
        JSONObject jsonObject = new JSONObject();
        JsonUtils.setSafeString(jsonObject, "domain", this.domain);
        JsonUtils.setSafeString(jsonObject, "parent", this.parent);
        JsonUtils.setSafeString(jsonObject, "ip", this.ip);
        JsonUtils.setSafeString(jsonObject, "port", this.port);
        JsonUtils.setSafeString(jsonObject, "name", this.name);
        JsonUtils.setSafeString(jsonObject, "tunnel", this.tunnel);
        JsonUtils.setSafeString(jsonObject, "banner", this.banner);
        JsonUtils.setSafeString(jsonObject, "protocol", this.protocol);
        JsonUtils.setSafeString(jsonObject, "state", this.state);
        JsonUtils.setSafeString(jsonObject, "product", this.product);
        JsonUtils.setSafeString(jsonObject, "version", this.version);
        return jsonObject.toString();
    }

    @Override
    public void fromJson(String json) {
        JSONObject jsonObject = new JSONObject(json);
        this.domain = JsonUtils.getSafeString(jsonObject, "domain");
        this.parent = JsonUtils.getSafeString(jsonObject, "parent");
        this.ip = JsonUtils.getSafeString(jsonObject, "ip");
        this.port = JsonUtils.getSafeString(jsonObject, "port");
        this.name = JsonUtils.getSafeString(jsonObject, "name");
        this.tunnel = JsonUtils.getSafeString(jsonObject, "tunnel");
        this.banner = JsonUtils.getSafeString(jsonObject, "banner");
        this.protocol = JsonUtils.getSafeString(jsonObject, "protocol");
        this.state = JsonUtils.getSafeString(jsonObject, "state");
        this.product = JsonUtils.getSafeString(jsonObject, "product");
        this.version = JsonUtils.getSafeString(jsonObject, "version");
    }

    @Override
    public <T extends DatalakeStorageItem> T fromDatalake(JSONObject object) {
        return (T)(object == null ? null : new Service(JsonUtils.getSafeString(object, "domain"), JsonUtils.getSafeString(object, "ip"), JsonUtils.getSafeString(object, "port"), JsonUtils.getSafeString(object, "name"), JsonUtils.getSafeString(object, "tunnel"), JsonUtils.getSafeString(object, "protocol"), JsonUtils.getSafeString(object, "state"), JsonUtils.getSafeString(object, "product"), JsonUtils.getSafeString(object, "version"), JsonUtils.getSafeString(object, "parent")));
    }

    @Override
    public boolean upsert() throws DatalakeStorageException {
        boolean result;
        boolean bl = result = this.find() != null;
        if (result) {
            result &= this.upsertField("domain", this.domain);
            result &= this.upsertField("ip", this.ip);
            result &= this.upsertField("port", this.port);
            result &= this.upsertField("name", this.name);
            result &= this.upsertField("tunnel", this.tunnel);
            result &= this.upsertField("protocol", this.protocol);
            result &= this.upsertField("state", this.state);
            result &= this.upsertField("product", this.product);
            result &= this.upsertField("version", this.version);
        }
        return result;
    }

    @Override
    public String getFanoutExchangeName() {
        return "com.michelin.cert.fanout.services";
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTunnel() {
        return this.tunnel;
    }

    public void setTunnel(String tunnel) {
        this.tunnel = tunnel;
    }

    public String getBanner() {
        return this.banner;
    }

    public void setBanner(String banner) {
        this.banner = banner;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

