/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cert.redscan.utils.network;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.logging.log4j.LogManager;

public class NetworkUtils {
    public static boolean isLocalhost(String domain) {
        boolean result = false;
        if (domain != null) {
            try {
                result = InetAddress.getByName(domain).isAnyLocalAddress() || InetAddress.getByName(domain).isLoopbackAddress();
            }
            catch (UnknownHostException ex) {
                LogManager.getLogger(NetworkUtils.class).info(String.format("Unknown host : %s", domain));
            }
            catch (Exception ex) {
                LogManager.getLogger(NetworkUtils.class).error(String.format("Exception : %s", ex.getMessage()));
            }
        }
        return result;
    }

    public static boolean isLocal(String domain) {
        boolean result = false;
        if (domain != null) {
            try {
                result = InetAddress.getByName(domain).isLinkLocalAddress();
            }
            catch (UnknownHostException ex) {
                LogManager.getLogger(NetworkUtils.class).info(String.format("Unknown host : %s", domain));
            }
            catch (Exception ex) {
                LogManager.getLogger(NetworkUtils.class).error(String.format("Exception : %s", ex.getMessage()));
            }
        }
        return result;
    }
}

