/*
 * Decompiled with CFR 0.152.
 */
package red.honey.oss.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import red.honey.oss.annotation.SecondTrans;
import red.honey.oss.api.constant.FileState;
import red.honey.oss.api.dto.FileDto;
import red.honey.oss.api.dto.FileShardDto;
import red.honey.oss.api.dto.HoneyStream;
import red.honey.oss.api.entiy.CallBack;
import red.honey.oss.api.entiy.Response;
import red.honey.oss.api.entiy.Thumbnail;
import red.honey.oss.api.service.dubbo.FileRpcService;
import red.honey.oss.api.service.dubbo.FileShardRpcService;
import red.honey.oss.api.service.dubbo.PureFileRpcService;
import red.honey.oss.api.service.dubbo.ThumbnailRpcService;
import red.honey.oss.api.utils.HoneyFileUtil;
import red.honey.oss.client.HoneyMiniO;
import red.honey.oss.task.AsyncTask;
import red.honey.oss.utils.BeanConverter;
import red.honey.oss.utils.HoneyWarpUtils;

public class HoneyOss {
    private static final Logger log = LoggerFactory.getLogger(HoneyOss.class);
    private final Integer SPILT_COUNT = 5;
    @Reference(version="1.0")
    private FileRpcService fileRpcService;
    @Reference(version="1.0")
    private FileShardRpcService fileShardRpcService;
    @Reference(version="1.0")
    private ThumbnailRpcService thumbnailRpcService;
    @Reference(version="1.0")
    private PureFileRpcService postFileRpcService;
    @Autowired
    private AsyncTask asyncTask;
    @Autowired
    private HoneyMiniO honeyMiniO;
    private ThreadPoolExecutor pool = new ThreadPoolExecutor(10, 20, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

    @SecondTrans(bucketName="${honey.oss.minio.bucketName}")
    public Response<String> upload(File file, String bucketName, MediaType contentType) {
        FileDto fileDto = BeanConverter.convert2FileDto(file);
        fileDto.setBucketName(bucketName);
        return this.upload(fileDto, bucketName, contentType);
    }

    @SecondTrans(bucketName="${honey.oss.minio.bucketName}")
    public Response<FileShardDto> uploadByShard(String filePath, String bucketName, MediaType contentType) throws IOException, InterruptedException {
        File file = new File(filePath);
        FileDto fileDto = HoneyFileUtil.convertFileDto((File)file);
        ArrayList<FileShardDto> shardDtos = new ArrayList<FileShardDto>();
        long shardSize = HoneyFileUtil.spiltFile((String)filePath, (int)this.SPILT_COUNT);
        for (int i = 0; i < this.SPILT_COUNT; ++i) {
            FileShardDto fileShardDto = new FileShardDto();
            fileShardDto.setUid(HoneyFileUtil.get32Uid());
            fileShardDto.setFileKey(fileDto.getFileKey());
            fileShardDto.setShardIndex(i);
            fileShardDto.setShardName(HoneyFileUtil.buildShardName((String)fileDto.getFileName(), (int)i));
            fileShardDto.setShardState(FileState.UPLOADING.getStateCode());
            fileShardDto.setHoneyStream(new HoneyStream((InputStream)FileUtils.openInputStream((File)new File(filePath + "_" + i + ".tmp"))));
            shardDtos.add(fileShardDto);
        }
        fileDto.setShardTotal(this.SPILT_COUNT.intValue());
        fileDto.setShardSize(shardSize);
        fileDto.setFileShardDtos(shardDtos);
        return this.uploadByShard(fileDto, bucketName, contentType);
    }

    private Response<FileShardDto> uploadByShard(FileDto fileDto, String bucketName, MediaType contentType) throws InterruptedException {
        boolean isExit;
        boolean bl = isExit = this.fileRpcService.getFileByFileKeys(Collections.singletonList(fileDto.getFileKey())).size() > 0;
        if (!isExit) {
            fileDto.setBucketName(bucketName);
            this.postFileRpcService.postFileInfo(fileDto);
        }
        List fileShardDtos = fileDto.getFileShardDtos();
        Assert.notEmpty((Collection)fileShardDtos, (String)"File shards must not empty");
        return this.shardProcess(fileDto, bucketName, contentType, fileShardDtos);
    }

    private Response<FileShardDto> shardProcess(FileDto fileDto, String bucketName, MediaType contentType, List<FileShardDto> fileShardDtos) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(fileShardDtos.size());
        List<FileShardDto> success = Collections.synchronizedList(new ArrayList());
        List<FileShardDto> failures = Collections.synchronizedList(new ArrayList());
        fileShardDtos.forEach(fileShardDto -> this.pool.execute(() -> this.shardUpload(bucketName, contentType, (FileShardDto)fileShardDto, latch, success, failures)));
        latch.await();
        return this.responseWarp(fileDto, fileShardDtos, success, failures);
    }

    private Response<FileShardDto> responseWarp(FileDto fileDto, List<FileShardDto> fileShardDtos, List<FileShardDto> success, List<FileShardDto> failures) {
        Response response = new Response();
        response.setSuccess(success);
        response.setFailures(failures);
        if (success.size() == fileShardDtos.size()) {
            response.setFileKey(fileDto.getFileKey());
            this.fileRpcService.updateFileState(fileDto.getFileKey(), FileState.SUCCESS);
            this.asyncTask.composeShard(fileDto.getBucketName(), fileShardDtos, HoneyFileUtil.buildObjectNameByFileKey((String)fileDto.getFileName(), (String)fileDto.getFileKey()));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shardUpload(String bucketName, MediaType contentType, FileShardDto fileShardDto, CountDownLatch latch, List<FileShardDto> success, List<FileShardDto> failures) {
        try {
            String objectName = HoneyFileUtil.buildObjectNameByFileKey((String)fileShardDto.getShardName(), (String)fileShardDto.getFileKey());
            this.honeyMiniO.upload(bucketName, objectName, fileShardDto.getHoneyStream().getInputStream(), contentType);
            fileShardDto.setShardState(FileState.SUCCESS.getStateCode());
            this.fileShardRpcService.addFileShard(fileShardDto);
            success.add(fileShardDto);
        }
        catch (Exception e) {
            failures.add(fileShardDto);
        }
        finally {
            latch.countDown();
        }
    }

    private Response<String> upload(FileDto fileDto, String bucketName, MediaType contentType) {
        this.postFileRpcService.postFileInfo(fileDto);
        String objectName = HoneyFileUtil.buildObjectNameByFileKey((String)fileDto.getFileName(), (String)fileDto.getFileKey());
        this.honeyMiniO.upload(bucketName, objectName, fileDto.getHoneyStream().getInputStream(), contentType);
        this.fileRpcService.updateFileState(fileDto.getFileKey(), FileState.SUCCESS);
        return HoneyWarpUtils.warpResponse(fileDto.getFileKey());
    }

    public void asyncUpload(File file, String bucketName, MediaType contentType, CallBack callBack) {
    }

    public String downAsUrl(String bucketName, String fileKey) {
        return this.fileRpcService.downAsUrl(bucketName, fileKey);
    }

    public String downAsUrl(String bucketName, String fileKey, Integer expires) {
        return this.fileRpcService.downAsUrl(bucketName, fileKey, expires);
    }

    public InputStream downAsStream(String bucketName, String fileKey) {
        String objectName = this.objectName(fileKey, bucketName);
        return this.honeyMiniO.downAsStream(bucketName, objectName);
    }

    public void down2Local(String bucketName, String fileKey, String fileDownPath) {
        String objectName = this.objectName(fileKey, bucketName);
        this.honeyMiniO.down2Local(bucketName, objectName, fileDownPath);
    }

    public String uploadImage(File image, String bucketName, MediaType contentType, boolean needThumbnail) {
        String fileKey = this.upload(image, bucketName, contentType).getFileKey();
        if (needThumbnail) {
            Thumbnail defaultThumbnail = this.thumbnailRpcService.defaultThumbnail(image);
            this.thumbnailHandle(bucketName, contentType, fileKey, defaultThumbnail);
        }
        return fileKey;
    }

    public String uploadImage(File image, String bucketName, MediaType contentType, Thumbnail thumbnail) {
        String fileKey = this.upload(image, bucketName, contentType).getFileKey();
        thumbnail = this.thumbnailRpcService.buildThumbnail(thumbnail);
        this.thumbnailHandle(bucketName, contentType, fileKey, thumbnail);
        return fileKey;
    }

    public String getUrlByOriginalPicture(String bucketName, String fileKey) {
        String thumbnailFileKey = HoneyFileUtil.getThumbnailFileKey((String)fileKey);
        return this.downAsUrl(bucketName, thumbnailFileKey);
    }

    public String getUrlByOriginalPicture(String bucketName, String fileKey, Integer expires) {
        String thumbnailFileKey = HoneyFileUtil.getThumbnailFileKey((String)fileKey);
        return this.downAsUrl(bucketName, thumbnailFileKey, expires);
    }

    public void down2LocalByOriginalPicture(String bucketName, String fileKey, String fileDownPath) {
        String thumbnailFileKey = HoneyFileUtil.getThumbnailFileKey((String)fileKey);
        this.down2Local(bucketName, thumbnailFileKey, fileDownPath);
    }

    public List<FileDto> getFileByIds(List<String> ids) {
        return this.fileRpcService.getFileByIds(ids);
    }

    public List<FileDto> getFileByFileKeys(List<String> fileKeys) {
        return this.fileRpcService.getFileByFileKeys(fileKeys);
    }

    public boolean updateFileName(String fileId, String fileName) {
        return this.fileRpcService.updateFileName(fileId, fileName);
    }

    public boolean deleteFileByIds(List<String> ids) {
        return this.fileRpcService.deleteFileByIds(ids);
    }

    public boolean deletedFileByFileKeys(List<String> fileKeys) {
        return this.fileRpcService.deletedFileByFileKeys(fileKeys);
    }

    private String objectName(String fileKey, String bucketName) {
        String fileName = this.fileRpcService.getFileByFileKeys(Collections.singletonList(fileKey)).stream().filter(e -> e.getBucketName().equals(bucketName)).map(FileDto::getFileName).findFirst().orElseThrow(() -> new IllegalArgumentException("fileKey not found"));
        return HoneyFileUtil.buildObjectNameByFileKey((String)fileName, (String)fileKey);
    }

    private void thumbnailHandle(String bucketName, MediaType contentType, String fileKey, Thumbnail defaultThumbnail) {
        String filePath = defaultThumbnail.getOutputMode().getFilePath();
        File thumbnail = new File(filePath);
        FileDto fileDto = BeanConverter.convert2FileDto(thumbnail);
        String thumbnailFileKey = HoneyFileUtil.getThumbnailFileKey((String)fileKey);
        fileDto.setFileKey(thumbnailFileKey);
        fileDto.setBucketName(bucketName);
        this.upload(fileDto, bucketName, contentType);
    }
}

