/*
 * Decompiled with CFR 0.152.
 */
package red.honey.oss.aspect;

import java.io.File;
import org.apache.dubbo.config.annotation.Reference;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import red.honey.oss.annotation.Callback;
import red.honey.oss.api.dto.FileDto;
import red.honey.oss.api.entiy.CallBack;
import red.honey.oss.api.service.dubbo.PureFileRpcService;
import red.honey.oss.api.utils.HoneyFileUtil;
import red.honey.oss.strategy.CallbackStrategy;
import red.honey.oss.task.AsyncTask;
import red.honey.oss.utils.AnnotationUtils;

@Aspect
@Order(value=1)
public class CallbackAspect
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CallbackAspect.class);
    @Reference(version="1.0")
    private PureFileRpcService postFileRpcService;
    private ApplicationContext applicationContext;
    @Autowired
    private Environment environment;
    @Autowired
    private AsyncTask asyncTask;

    @Pointcut(value="@annotation(red.honey.oss.annotation.Callback)")
    public void callbackPointcut() {
    }

    @Around(value="callbackPointcut()")
    public void callbackPointcutProcess(ProceedingJoinPoint jointPoint) {
        boolean hasAnnotation = AnnotationUtils.hasAnnotation(jointPoint, Callback.class);
        if (hasAnnotation) {
            CallbackStrategy bean;
            Callback annotation = (Callback)AnnotationUtils.getAnnotation(jointPoint, Callback.class);
            Class<? extends CallbackStrategy> type = annotation.type();
            try {
                bean = (CallbackStrategy)this.applicationContext.getBean(type);
            }
            catch (NoUniqueBeanDefinitionException nue) {
                throw nue;
            }
            catch (NoSuchBeanDefinitionException nbe) {
                bean = (CallbackStrategy)this.applicationContext.getBean(CallbackStrategy.class);
            }
            Object[] args = jointPoint.getArgs();
            File file = null;
            String bucketName = null;
            MediaType contentType = null;
            CallBack callBack = new CallBack();
            for (Object arg : args) {
                if (arg instanceof File) {
                    file = (File)arg;
                    continue;
                }
                if (arg instanceof String) {
                    bucketName = (String)arg;
                    continue;
                }
                if (arg instanceof MediaType) {
                    contentType = (MediaType)arg;
                    continue;
                }
                if (!(arg instanceof CallBack)) continue;
                callBack = (CallBack)arg;
            }
            Assert.state((file != null || !StringUtils.isEmpty(bucketName) || contentType != null ? 1 : 0) != 0, (String)"file and bucketName or contentType all must not be null or empty");
            FileDto fileDto = HoneyFileUtil.convertFileDto(file);
            fileDto.setBucketName(bucketName);
            if (AnnotationUtils.conditionOnSecondTrans(jointPoint, this.applicationContext, this.environment)) {
                this.callbackOnSecondTrans(callBack, fileDto.getFileKey(), bean);
            } else {
                this.postFileRpcService.postFileInfo(fileDto);
                try {
                    jointPoint.proceed();
                }
                catch (Throwable throwable) {
                    log.error("aop happen error {}", (Object)throwable.getMessage());
                }
                this.asyncTask.asyncUpload(fileDto, bucketName, contentType, callBack, bean);
            }
        }
    }

    private void callbackOnSecondTrans(CallBack callBack, String data, CallbackStrategy bean) {
        callBack.setMsg("\u79d2\u4f20success");
        callBack.setCode(200);
        callBack.setData((Object)data);
        bean.callbackProcess(callBack);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

