/*
 * Decompiled with CFR 0.152.
 */
package red.honey.oss.aspect;

import java.io.File;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import red.honey.oss.annotation.SecondTrans;
import red.honey.oss.api.dto.FileDto;
import red.honey.oss.utils.AnnotationUtils;
import red.honey.oss.utils.BeanConverter;
import red.honey.oss.utils.HoneyWarpUtils;

@Aspect
@Order(value=2)
public class SecondTransAspect
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SecondTransAspect.class);
    @Autowired
    private Environment environment;
    private ApplicationContext applicationContext;

    @Pointcut(value="@annotation(red.honey.oss.annotation.SecondTrans) && !@annotation(red.honey.oss.annotation.Callback)")
    public void secondTransPointcut() {
    }

    @Around(value="secondTransPointcut()")
    public Object secondTransProcess(ProceedingJoinPoint jointPoint) {
        boolean hasAnnotation = AnnotationUtils.hasAnnotation(jointPoint, SecondTrans.class);
        if (hasAnnotation) {
            boolean conditionOnSecondTrans = AnnotationUtils.conditionOnSecondTrans(jointPoint, this.applicationContext, this.environment);
            try {
                if (!conditionOnSecondTrans) {
                    return jointPoint.proceed();
                }
                File file = AnnotationUtils.getFile(jointPoint);
                FileDto fileDto = BeanConverter.convert2FileDto(file);
                return HoneyWarpUtils.warpResponse(fileDto.getFileKey());
            }
            catch (Throwable throwable) {
                log.error("aop happen error {}", (Object)throwable.getMessage());
            }
        }
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

