/*
 * Decompiled with CFR 0.152.
 */
package red.honey.oss.client;

import io.minio.BucketExistsArgs;
import io.minio.ComposeObjectArgs;
import io.minio.ComposeSource;
import io.minio.DownloadObjectArgs;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.UploadObjectArgs;
import io.minio.http.Method;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import red.honey.oss.api.dto.FileShardDto;
import red.honey.oss.api.utils.HoneyFileUtil;
import red.honey.oss.utils.HoneyIOUtil;

public class HoneyMiniO {
    private static final Logger log = LoggerFactory.getLogger(HoneyMiniO.class);
    @Autowired
    MinioClient minioClient;

    public void upload(String bucketName, String objectName, String filePath, MediaType contentType) {
        try {
            this.checkBucket(bucketName);
            this.minioClient.uploadObject((UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(bucketName)).object(objectName)).filename(filePath).contentType(contentType.toString()).build());
        }
        catch (Exception e) {
            log.warn("\u4e0a\u4f20\u5931\u8d25\uff1a\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void upload(String bucketName, String objectName, long size, InputStream inputStream, MediaType contentType) {
        try {
            this.checkBucket(bucketName);
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream(inputStream, size, -1L).contentType(contentType.toString()).build());
        }
        catch (Exception e) {
            log.warn("\u4e0a\u4f20\u5931\u8d25\uff1a\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            HoneyIOUtil.closeQuietly(inputStream);
        }
    }

    public void upload(String bucketName, String objectName, InputStream inputStream, MediaType contentType) {
        try {
            this.checkBucket(bucketName);
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream(inputStream, (long)inputStream.available(), -1L).contentType(contentType.toString()).build());
        }
        catch (Exception e) {
            log.warn("\u4e0a\u4f20\u5931\u8d25\uff1a\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            HoneyIOUtil.closeQuietly(inputStream);
        }
    }

    public String uploadAndGetUrl(String bucketName, String objectName, InputStream inputStream, MediaType contentType) {
        try {
            this.checkBucket(bucketName);
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream(inputStream, (long)inputStream.available(), -1L).contentType(contentType.toString()).build());
            String string = this.downAsUrl(bucketName, objectName);
            return string;
        }
        catch (Exception e) {
            log.warn("\u4e0a\u4f20\u5931\u8d25\uff1a\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            HoneyIOUtil.closeQuietly(inputStream);
        }
    }

    public void down2Local(String bucketName, String objectName, String fileDownPath) {
        try {
            this.minioClient.downloadObject((DownloadObjectArgs)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)DownloadObjectArgs.builder().bucket(bucketName)).object(objectName)).filename(fileDownPath).build());
        }
        catch (Exception e) {
            log.warn("\u4e0b\u8f7d\u5931\u8d25\uff1a\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public InputStream downAsStream(String bucketName, String objectName) {
        try {
            return this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
        }
        catch (Exception e) {
            log.warn("\u4e0b\u8f7d\u5931\u8d25\uff1a\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public String downAsUrl(String bucketName, String objectName) {
        try {
            return this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(objectName)).build());
        }
        catch (Exception e) {
            log.warn("\u4e0b\u8f7d\u5931\u8d25\uff1a\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public String downAsUrl(String bucketName, String objectName, int duration, TimeUnit unit) {
        try {
            return this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(objectName)).expiry(duration, unit).build());
        }
        catch (Exception e) {
            log.warn("\u4e0b\u8f7d\u5931\u8d25\uff1a\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public ObjectWriteResponse compose(String bucketName, List<FileShardDto> fileShardDtos, String objectName) {
        ArrayList sourceObjectList = new ArrayList();
        fileShardDtos.forEach(fileShardDto -> {
            String shardObjectName = HoneyFileUtil.buildObjectNameByFileKey((String)fileShardDto.getShardName(), (String)fileShardDto.getFileKey());
            sourceObjectList.add(((ComposeSource.Builder)((ComposeSource.Builder)ComposeSource.builder().bucket(bucketName)).object(shardObjectName)).build());
        });
        try {
            return this.minioClient.composeObject((ComposeObjectArgs)((ComposeObjectArgs.Builder)((ComposeObjectArgs.Builder)ComposeObjectArgs.builder().bucket(bucketName)).object(objectName)).sources(sourceObjectList).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkBucket(String bucketName) throws Exception {
        boolean isExist = this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
        if (!isExist) {
            this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
        }
    }
}

