/*
 * Decompiled with CFR 0.152.
 */
package red.honey.oss.config;

import io.minio.MinioClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import red.honey.oss.api.HoneyOss;
import red.honey.oss.aspect.CallbackAspect;
import red.honey.oss.aspect.SecondTransAspect;
import red.honey.oss.client.HoneyMiniO;
import red.honey.oss.config.AsyncConfig;
import red.honey.oss.config.RestTemplateConfig;
import red.honey.oss.properties.MinioProperties;
import red.honey.oss.strategy.CallbackStrategy;
import red.honey.oss.strategy.SecondTransStrategy;
import red.honey.oss.strategy.impl.Md5DigestAsHex;
import red.honey.oss.strategy.impl.RestCallback;
import red.honey.oss.task.AsyncTask;

@Lazy
@Configuration
@ConditionalOnClass(value={HoneyOss.class})
@Import(value={RestTemplateConfig.class, AsyncConfig.class})
public class HoneyOssAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HoneyOssAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public HoneyOss honeyOss() {
        return new HoneyOss();
    }

    @Bean
    @ConditionalOnMissingBean
    public HoneyMiniO honeyMiniO() {
        return new HoneyMiniO();
    }

    @Bean
    public MinioProperties minioProperties() {
        return new MinioProperties();
    }

    @Bean
    @ConditionalOnMissingBean(value={MinioClient.class})
    public MinioClient minioClient(@Qualifier(value="minioProperties") MinioProperties minioProperties) {
        return MinioClient.builder().endpoint(minioProperties.getUrl()).credentials(minioProperties.getAccessKey(), minioProperties.getSecretKey()).build();
    }

    @Bean
    public SecondTransAspect secondTransAspect() {
        return new SecondTransAspect();
    }

    @Bean
    public CallbackAspect callbackAspect() {
        return new CallbackAspect();
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={Md5DigestAsHex.class})
    public SecondTransStrategy secondTransStrategy() {
        return new Md5DigestAsHex();
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={RestCallback.class})
    public CallbackStrategy callbackStrategy() {
        return new RestCallback();
    }

    @Bean
    public AsyncTask asyncTask() {
        return new AsyncTask();
    }
}

