/*
 * Decompiled with CFR 0.152.
 */
package red.honey.oss.task;

import java.util.List;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import red.honey.oss.api.constant.FileState;
import red.honey.oss.api.dto.FileDto;
import red.honey.oss.api.dto.FileShardDto;
import red.honey.oss.api.entiy.CallBack;
import red.honey.oss.api.service.dubbo.FileRpcService;
import red.honey.oss.api.utils.CallBackUtil;
import red.honey.oss.api.utils.HoneyFileUtil;
import red.honey.oss.client.HoneyMiniO;
import red.honey.oss.strategy.CallbackStrategy;

@Component
public class AsyncTask {
    private static final Logger log = LoggerFactory.getLogger(AsyncTask.class);
    @Reference(version="1.0")
    private FileRpcService fileService;
    @Autowired
    private HoneyMiniO honeyMiniO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="asyncExecutor")
    public void asyncUpload(FileDto file, String bucketName, MediaType contentType, CallBack callBack, CallbackStrategy callbackStrategy) {
        String msg = "success";
        String data = file.getFileKey();
        int code = 200;
        try {
            String objectName = HoneyFileUtil.buildObjectNameByFileKey((String)file.getFileName(), (String)file.getFileKey());
            this.honeyMiniO.upload(bucketName, objectName, file.getHoneyStream().getInputStream(), contentType);
            this.fileService.updateFileState(file.getFileKey(), FileState.SUCCESS);
        }
        catch (Exception e) {
            code = 500;
            msg = e.getMessage();
            data = null;
        }
        finally {
            callBack = CallBackUtil.buildCallback((String)data, (String)callBack.getCallBackHttpUrl(), (int)code, (String)msg);
            callbackStrategy.callbackProcess(callBack);
        }
    }

    @Async(value="asyncExecutor")
    public void composeShard(String bucketName, List<FileShardDto> fileShardDtos, String objectName) {
        this.honeyMiniO.compose(bucketName, fileShardDtos, objectName);
    }
}

